/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.exception.CattleException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.cattleframework.utils.auxiliary.BarcodeResult;

public final class BarcodeUtils {
    private static final String IMAGE_DEFAULT_FORMAT = "png";

    private BarcodeUtils() {
    }

    public static void createBarcode(OutputStream outputStream, String content, int width, int height, int margin, Charset charset, ErrorCorrectionLevel errorCorrectionLevel, Color front, Color background, String format) {
        MatrixToImageConfig config = new MatrixToImageConfig(front == null ? Color.BLACK.getRGB() : front.getRGB(), background == null ? Color.WHITE.getRGB() : background.getRGB());
        BitMatrix matrix = BarcodeUtils.createBarcode(content, width, height, margin, charset, errorCorrectionLevel);
        try {
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)(StringUtils.isBlank((CharSequence)format) ? IMAGE_DEFAULT_FORMAT : format), (OutputStream)outputStream, (MatrixToImageConfig)config);
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static void createLogoBarcode(OutputStream outputStream, String content, InputStream logoInputStream, int width, int height, int margin, Charset charset, ErrorCorrectionLevel errorCorrectionLevel, Color front, Color background, String format) {
        MatrixToImageConfig config = new MatrixToImageConfig(front == null ? Color.BLACK.getRGB() : front.getRGB(), background == null ? Color.WHITE.getRGB() : background.getRGB());
        BitMatrix matrix = BarcodeUtils.createBarcode(content, width, height, margin, charset, errorCorrectionLevel);
        int qrWidth = matrix.getWidth();
        int qrHeight = matrix.getHeight();
        BufferedImage qrImage = new BufferedImage(qrWidth, qrHeight, 1);
        for (int x = 0; x < qrWidth; ++x) {
            for (int y = 0; y < qrHeight; ++y) {
                qrImage.setRGB(x, y, matrix.get(x, y) ? config.getPixelOnColor() : config.getPixelOffColor());
            }
        }
        try {
            BufferedImage logoImage = ImageIO.read(logoInputStream);
            Graphics2D g2 = qrImage.createGraphics();
            int matrixWidth = qrImage.getWidth();
            int matrixHeigh = qrImage.getHeight();
            g2.drawImage(logoImage, matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, null);
            BasicStroke stroke = new BasicStroke(5.0f, 1, 1);
            g2.setStroke(stroke);
            RoundRectangle2D.Float round = new RoundRectangle2D.Float(matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, 20.0f, 20.0f);
            g2.setColor(Color.white);
            g2.draw(round);
            BasicStroke stroke2 = new BasicStroke(1.0f, 1, 1);
            g2.setStroke(stroke2);
            RoundRectangle2D.Float round2 = new RoundRectangle2D.Float(matrixWidth / 5 * 2 + 2, matrixHeigh / 5 * 2 + 2, matrixWidth / 5 - 4, matrixHeigh / 5 - 4, 20.0f, 20.0f);
            g2.setColor(new Color(128, 128, 128));
            g2.draw(round2);
            g2.dispose();
            qrImage.flush();
            if (!ImageIO.write((RenderedImage)qrImage, StringUtils.isBlank((CharSequence)format) ? IMAGE_DEFAULT_FORMAT : format, outputStream)) {
                throw new CattleException("\u4e0d\u80fd\u751f\u6210\u56fe\u7247\u683c\u5f0f:" + format);
            }
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    private static BitMatrix createBarcode(String content, int width, int height, int margin, Charset charset, ErrorCorrectionLevel errorCorrectionLevel) {
        try {
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(3);
            hints.put(EncodeHintType.CHARACTER_SET, charset == null ? CharacterSetECI.UTF8 : charset);
            hints.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel == null ? ErrorCorrectionLevel.H : errorCorrectionLevel);
            hints.put(EncodeHintType.MARGIN, margin);
            return new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BarcodeResult scan(byte[] imageBytes, Charset charset) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);){
            BufferedImage bi = ImageIO.read(bais);
            if (bi != null) {
                BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(bi);
                BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
                HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>(2);
                hints.put(DecodeHintType.CHARACTER_SET, charset == null ? CharacterSetECI.UTF8 : charset);
                hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
                Result result = new MultiFormatReader().decode(bitmap, hints);
                BarcodeResult barcodeResult = new BarcodeResult(result.getText(), result.getBarcodeFormat().toString());
                return barcodeResult;
            }
            BarcodeResult barcodeResult = null;
            return barcodeResult;
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

