/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils;

import java.util.Iterator;
import java.util.Map;
import org.cattleframework.aop.annotation.GuiceBindBean;
import org.cattleframework.utils.MessageSourceProperties;
import org.cattleframework.utils.cache.CacheManager;
import org.cattleframework.utils.cache.caffeine.CaffeineCacheManager;
import org.cattleframework.utils.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;

@AutoConfiguration
@Import(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={MessageSourceProperties.class})
public class UtilsAutoConfiguration {
    @Bean
    public MessageSource messageSource(MessageSourceProperties messageSourceProperties) {
        ResourceBundleMessageSource resourceBundleMessageSource = new ResourceBundleMessageSource();
        Map<String, String> baseName = messageSourceProperties.getBaseName();
        if (baseName != null && baseName.size() > 0) {
            String[] baseNames = new String[baseName.size()];
            Iterator<String> iterator = baseName.keySet().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                String key = iterator.next();
                String lName = baseName.get(key) + "/" + key;
                baseNames[index] = lName;
                ++index;
            }
            resourceBundleMessageSource.setBasenames(baseNames);
        }
        resourceBundleMessageSource.setDefaultEncoding("UTF-8");
        return resourceBundleMessageSource;
    }

    @Bean
    public MessageSourceAccessor messageSourceAccessor(MessageSource messageSource) {
        return new MessageSourceAccessor(messageSource);
    }

    @Bean
    @ConditionalOnClass(name={"com.github.benmanes.caffeine.cache.Caffeine"})
    @GuiceBindBean
    public CacheManager caffeineCacheManager() {
        return new CaffeineCacheManager();
    }
}

