/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.cache;

import java.util.Map;

/**
 * 缓存管理器
 * 
 * @author orange
 *
 */
public interface CacheManager {

    /**
     * 获得缓存
     * 
     * @param name  名称
     * @param props 属性
     * @return 缓存
     */
    Cache getCache(String name, Map<String, String> props);

    /**
     * 移除缓存
     * 
     * @param name 名称
     */
    void removeCache(String name);
}