/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.auxiliary;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.RandomBasedGenerator;

/**
 * Uuid工具
 * 
 * @author orange
 *
 */
public final class UuidUtils {

    private static RandomBasedGenerator randomBasedGenerator;

    private UuidUtils() {
    }

    static {
	if (randomBasedGenerator == null) {
	    synchronized (UuidUtils.class) {
		if (randomBasedGenerator == null) {
		    randomBasedGenerator = Generators.randomBasedGenerator();
		}
	    }
	}
    }

    public static String getUuid() {
	return randomBasedGenerator.generate().toString().replace("-", "");
    }
}