/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.client;

import io.georocket.client.AbstractClient;
import io.georocket.client.ClientAPIException;
import io.georocket.client.ImportParams;
import io.georocket.client.ImportResult;
import io.georocket.client.SearchParams;
import io.georocket.client.SearchReadStream;
import io.georocket.client.SearchResult;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StoreClient
extends AbstractClient {
    public StoreClient(HttpClient client) {
        super(client);
    }

    protected String prepareImport(String layer, Collection<String> tags) {
        return this.prepareImport(layer, tags, null, null);
    }

    protected String prepareImport(String layer, Collection<String> tags, Collection<String> properties) {
        return this.prepareImport(layer, tags, properties, null);
    }

    protected String prepareImport(String layer, Collection<String> tags, Collection<String> properties, String fallbackCRS) {
        boolean hasProperties;
        boolean hasTags;
        String path = this.getEndpoint();
        if (layer != null && !layer.isEmpty()) {
            if (!(layer = Stream.of(layer.split("/")).map(this::urlencode).collect(Collectors.joining("/"))).endsWith("/")) {
                layer = layer + "/";
            }
            if (!layer.startsWith("/")) {
                layer = "/" + layer;
            }
            path = path + layer;
        }
        boolean bl = hasTags = tags != null && !tags.isEmpty();
        if (hasTags) {
            path = path + "?tags=" + this.urlencode(String.join((CharSequence)",", tags));
        }
        boolean bl2 = hasProperties = properties != null && !properties.isEmpty();
        if (hasProperties) {
            path = hasTags ? path + "&props=" : path + "?props=";
            path = path + this.urlencode(String.join((CharSequence)",", properties));
        }
        if (fallbackCRS != null && !fallbackCRS.isEmpty()) {
            path = hasTags || hasProperties ? path + "&fallbackCRS=" : path + "?fallbackCRS=";
            path = path + this.urlencode(String.join((CharSequence)",", fallbackCRS));
        }
        return path;
    }

    private <T> Handler<AsyncResult<T>> ignoreResult(Handler<AsyncResult<Void>> handler) {
        return ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture());
            }
        };
    }

    public WriteStream<Buffer> startImport(Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams(), this.ignoreResult(handler));
    }

    public WriteStream<Buffer> startImport(String layer, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer), this.ignoreResult(handler));
    }

    @Deprecated
    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer).setTags(tags), this.ignoreResult(handler));
    }

    @Deprecated
    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Collection<String> properties, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer).setTags(tags).setProperties(properties), this.ignoreResult(handler));
    }

    @Deprecated
    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, long size, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer).setTags(tags).setSize(size), this.ignoreResult(handler));
    }

    @Deprecated
    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Collection<String> properties, long size, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer).setTags(tags).setProperties(properties).setSize(size), this.ignoreResult(handler));
    }

    @Deprecated
    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Optional<Long> size, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer).setTags(tags).setSize(size.orElse(null)), this.ignoreResult(handler));
    }

    @Deprecated
    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Collection<String> properties, Optional<Long> size, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer).setTags(tags).setProperties(properties).setSize(size.orElse(null)), this.ignoreResult(handler));
    }

    @Deprecated
    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Collection<String> properties, Optional<Long> size, String fallbackCRS, Handler<AsyncResult<Void>> handler) {
        return this.startImport(new ImportParams().setLayer(layer).setTags(tags).setProperties(properties).setSize(size.orElse(null)).setFallbackCRS(fallbackCRS), this.ignoreResult(handler));
    }

    public WriteStream<Buffer> startImport(ImportParams params, Handler<AsyncResult<ImportResult>> handler) {
        if (params == null) {
            params = new ImportParams();
        }
        String path = this.prepareImport(params.getLayer(), params.getTags(), params.getProperties(), params.getFallbackCRS());
        HttpClientRequest request = this.client.post(path);
        if (params.getSize() != null) {
            request.putHeader("Content-Length", params.getSize().toString());
        } else {
            request.setChunked(true);
        }
        if (params.getCompression() == ImportParams.Compression.GZIP) {
            request.putHeader("Content-Encoding", "gzip");
        }
        request.handler(response -> {
            if (response.statusCode() != 202) {
                StoreClient.fail(response, handler, message -> {
                    ClientAPIException e = ClientAPIException.parse(message);
                    String msg = String.format("GeoRocket did not accept the file (status code %s: %s) %s", response.statusCode(), response.statusMessage(), e.getMessage());
                    return new ClientAPIException(e.getType(), msg);
                });
            } else {
                handler.handle((Object)Future.succeededFuture((Object)new ImportResult()));
            }
        });
        return this.configureRequest(request);
    }

    public void search(Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        this.search(new SearchParams(), (Handler<AsyncResult<SearchResult>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((SearchResult)ar.result()).getResponse()));
            }
        }));
    }

    public void search(String query, Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        this.search(new SearchParams().setQuery(query), (Handler<AsyncResult<SearchResult>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((SearchResult)ar.result()).getResponse()));
            }
        }));
    }

    @Deprecated
    public void search(String query, String layer, Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        this.search(new SearchParams().setQuery(query).setLayer(layer), (Handler<AsyncResult<SearchResult>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((SearchResult)ar.result()).getResponse()));
            }
        }));
    }

    public void search(SearchParams params, Handler<AsyncResult<SearchResult>> handler) {
        if (params == null) {
            params = new SearchParams();
        }
        String query = params.getQuery();
        String layer = params.getLayer();
        if ((query == null || query.isEmpty()) && (layer == null || layer.isEmpty())) {
            handler.handle((Object)Future.failedFuture((String)"No search query and no layer given. Do you really wish to export/query the whole data store? If so, set the layer to '/'."));
            return;
        }
        String queryPath = this.prepareQuery(query, layer, params.isOptimisticMerging());
        HttpClientRequest request = this.client.get(this.getEndpoint() + queryPath);
        request.putHeader("TE", "trailers");
        request.exceptionHandler(t -> handler.handle((Object)Future.failedFuture((Throwable)t)));
        request.handler(response -> {
            if (response.statusCode() == 404) {
                StoreClient.fail(response, handler, message -> new NoSuchElementException(ClientAPIException.parse(message).getMessage()));
            } else if (response.statusCode() != 200) {
                StoreClient.fail(response, handler);
            } else {
                handler.handle((Object)Future.succeededFuture((Object)new SearchResult(new SearchReadStream((HttpClientResponse)response))));
            }
        });
        this.configureRequest(request).end();
    }

    public void delete(String query, Handler<AsyncResult<Void>> handler) {
        this.delete(query, null, handler);
    }

    public void delete(String query, String layer, Handler<AsyncResult<Void>> handler) {
        if ((query == null || query.isEmpty()) && (layer == null || layer.isEmpty())) {
            handler.handle((Object)Future.failedFuture((String)"No search query and no layer given. Do you really wish to delete the whole data store? If so, set the layer to '/'."));
            return;
        }
        String queryPath = this.prepareQuery(query, layer);
        HttpClientRequest request = this.client.delete(this.getEndpoint() + queryPath);
        request.exceptionHandler(t -> handler.handle((Object)Future.failedFuture((Throwable)t)));
        request.handler(response -> {
            if (response.statusCode() != 204) {
                StoreClient.fail(response, handler);
            } else {
                response.endHandler(v -> handler.handle((Object)Future.succeededFuture()));
            }
        });
        this.configureRequest(request).end();
    }

    public void setProperties(String query, String layer, List<String> properties, Handler<AsyncResult<Void>> handler) {
        this.update(HttpMethod.PUT, this.getEndpoint(), "properties", query, layer, properties, handler);
    }

    public void removeProperties(String query, String layer, List<String> properties, Handler<AsyncResult<Void>> handler) {
        this.update(HttpMethod.DELETE, this.getEndpoint(), "properties", query, layer, properties, handler);
    }

    public void appendTags(String query, String layer, List<String> tags, Handler<AsyncResult<Void>> handler) {
        this.update(HttpMethod.PUT, this.getEndpoint(), "tags", query, layer, tags, handler);
    }

    public void removeTags(String query, String layer, List<String> tags, Handler<AsyncResult<Void>> handler) {
        this.update(HttpMethod.DELETE, this.getEndpoint(), "tags", query, layer, tags, handler);
    }

    public void getPropertyValues(String property, String query, String layer, Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        this.getWithParameter(this.getEndpoint(), "property", property, query, layer, handler);
    }

    protected String getEndpoint() {
        return "/store";
    }
}

