/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.client;

import io.georocket.client.SearchReadStreamResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;

public class SearchReadStream
implements ReadStream<Buffer> {
    private static final Logger log = LoggerFactory.getLogger(SearchReadStream.class);
    private final HttpClientResponse delegate;
    private Handler<Throwable> exceptionHandler;

    public SearchReadStream(HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    public SearchReadStream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SearchReadStream handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public SearchReadStream pause() {
        this.delegate.pause();
        return this;
    }

    public SearchReadStream resume() {
        this.delegate.resume();
        return this;
    }

    public SearchReadStream endHandler(Handler<Void> endHandler) {
        this.endHandlerWithResult((Handler<SearchReadStreamResult>)((Handler)sr -> endHandler.handle(null)));
        return this;
    }

    public SearchReadStream endHandlerWithResult(Handler<SearchReadStreamResult> endHandler) {
        this.delegate.endHandler(v -> {
            String strUnmergedChunks = this.delegate.getTrailer("GeoRocket-Unmerged-Chunks");
            long unmergedChunks = 0L;
            if (strUnmergedChunks != null) {
                try {
                    unmergedChunks = Long.parseLong(strUnmergedChunks);
                }
                catch (NumberFormatException e) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Object)e);
                    } else {
                        log.error((Object)"Unhandled exception", (Throwable)e);
                    }
                    return;
                }
            }
            endHandler.handle((Object)new SearchReadStreamResult(unmergedChunks));
        });
        return this;
    }
}

