/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class ImportParams {
    private String layer;
    private Collection<String> tags;
    private Collection<String> properties;
    private Long size;
    private String fallbackCRS;
    private Compression compression = Compression.NONE;

    public ImportParams setLayer(String layer) {
        this.layer = layer;
        return this;
    }

    public String getLayer() {
        return this.layer;
    }

    public ImportParams setTags(Collection<String> tags) {
        this.tags = tags;
        return this;
    }

    public ImportParams addTags(Collection<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return this;
        }
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.addAll(tags);
        return this;
    }

    public ImportParams addTags(String ... tags) {
        if (tags == null || tags.length == 0) {
            return this;
        }
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public ImportParams addTag(String tag) {
        this.addTags(tag);
        return this;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public ImportParams setProperties(Collection<String> properties) {
        this.properties = properties;
        return this;
    }

    public ImportParams addProperties(Collection<String> properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.addAll(properties);
        return this;
    }

    public ImportParams addProperties(String ... properties) {
        if (properties == null || properties.length == 0) {
            return this;
        }
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    public ImportParams addProperty(String property) {
        this.addProperties(property);
        return this;
    }

    public Collection<String> getProperties() {
        return this.properties;
    }

    public ImportParams setSize(Long size) {
        this.size = size;
        return this;
    }

    public Long getSize() {
        return this.size;
    }

    public ImportParams setFallbackCRS(String fallbackCRS) {
        this.fallbackCRS = fallbackCRS;
        return this;
    }

    public String getFallbackCRS() {
        return this.fallbackCRS;
    }

    public ImportParams setCompression(Compression compression) {
        this.compression = compression == null ? Compression.NONE : compression;
        return this;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportParams that = (ImportParams)o;
        return Objects.equals(this.layer, that.layer) && Objects.equals(this.tags, that.tags) && Objects.equals(this.properties, that.properties) && Objects.equals(this.size, that.size) && Objects.equals(this.fallbackCRS, that.fallbackCRS) && this.compression == that.compression;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.layer, this.tags, this.properties, this.size, this.fallbackCRS, this.compression});
    }

    public static enum Compression {
        NONE,
        GZIP;

    }
}

