/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.client;

import io.georocket.client.StoreClient;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import java.io.Closeable;

public class GeoRocketClient
implements Closeable {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 63020;
    protected final HttpClient client;

    public GeoRocketClient(Vertx vertx) {
        this(DEFAULT_HOST, vertx);
    }

    public GeoRocketClient(String host, Vertx vertx) {
        this(host, 63020, vertx);
    }

    public GeoRocketClient(String host, int port, Vertx vertx) {
        this(vertx.createHttpClient(new HttpClientOptions().setDefaultHost(host).setDefaultPort(port).setTryUseCompression(true)));
    }

    public GeoRocketClient(HttpClientOptions options, Vertx vertx) {
        this(vertx.createHttpClient(options));
    }

    public GeoRocketClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public void close() {
        this.client.close();
    }

    public StoreClient getStore() {
        return new StoreClient(this.client);
    }
}

