/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.client;

import io.georocket.client.ClientAPIException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.streams.ReadStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AbstractClient {
    protected final HttpClient client;

    public AbstractClient(HttpClient client) {
        this.client = client;
    }

    protected void getWithParameter(String endpoint, String parameterName, String parameterValue, String query, String layer, Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        if ((query == null || query.isEmpty()) && (layer == null || layer.isEmpty())) {
            handler.handle((Object)Future.failedFuture((String)"No search query and no layer given. Do you really wish to export/query the whole data store? If so, set the layer to '/'."));
            return;
        }
        String queryPath = this.prepareQuery(query, layer);
        queryPath = query == null || query.isEmpty() ? queryPath + "?" : queryPath + "&";
        String path = endpoint + queryPath + parameterName + "=" + parameterValue;
        HttpClientRequest request = this.client.get(path);
        request.exceptionHandler(t -> handler.handle((Object)Future.failedFuture((Throwable)t)));
        request.handler(response -> {
            if (response.statusCode() != 200) {
                AbstractClient.fail(response, handler);
            } else {
                handler.handle((Object)Future.succeededFuture((Object)response));
            }
        });
        this.configureRequest(request).end();
    }

    protected void update(HttpMethod method, String fieldEndpoint, String fieldName, String query, String layer, List<String> updates, Handler<AsyncResult<Void>> handler) {
        if ((query == null || query.isEmpty()) && (layer == null || layer.isEmpty())) {
            handler.handle((Object)Future.failedFuture((String)"No search query and no layer given. Do you really wish to update all chunks in the GeoRocket data store? If so, set the layer to '/'."));
            return;
        }
        String queryPath = this.prepareQuery(query, layer);
        queryPath = query == null || query.isEmpty() ? queryPath + "?" : queryPath + "&";
        String values = updates.stream().map(this::urlencode).collect(Collectors.joining(","));
        String path = fieldEndpoint + queryPath + fieldName + "=" + values;
        HttpClientRequest request = this.client.request(method, path);
        request.exceptionHandler(t -> handler.handle((Object)Future.failedFuture((Throwable)t)));
        request.handler(response -> {
            if (response.statusCode() != 204) {
                AbstractClient.fail(response, handler);
            } else {
                response.endHandler(v -> handler.handle((Object)Future.succeededFuture()));
            }
        });
        this.configureRequest(request).end();
    }

    protected String prepareQuery(String query, String layer) {
        if (!(layer = layer == null || layer.isEmpty() ? "/" : Stream.of(layer.split("/")).map(this::urlencode).collect(Collectors.joining("/"))).endsWith("/")) {
            layer = layer + "/";
        }
        if (!layer.startsWith("/")) {
            layer = "/" + layer;
        }
        String urlQuery = "";
        if (query != null && !query.isEmpty()) {
            urlQuery = "?search=" + this.urlencode(query);
        }
        return layer + urlQuery;
    }

    protected String urlencode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpClientRequest configureRequest(HttpClientRequest request) {
        return request;
    }

    protected static <T> void fail(HttpClientResponse response, Handler<AsyncResult<T>> handler) {
        AbstractClient.fail(response, handler, ClientAPIException::parse);
    }

    protected static <T> void fail(HttpClientResponse response, Handler<AsyncResult<T>> handler, Function<String, Throwable> map) {
        response.bodyHandler(buffer -> handler.handle((Object)Future.failedFuture((Throwable)((Throwable)map.apply(buffer.toString())))));
    }
}

