/*
 * Decompiled with CFR 0.152.
 */
package io.georocket.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StoreClient {
    private final HttpClient client;

    public StoreClient(HttpClient client) {
        this.client = client;
    }

    protected String urlencode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String prepareQuery(String query, String layer) {
        if (!(layer = layer == null || layer.isEmpty() ? "/" : Stream.of(layer.split("/")).map(this::urlencode).collect(Collectors.joining("/"))).endsWith("/")) {
            layer = layer + "/";
        }
        if (!layer.startsWith("/")) {
            layer = "/" + layer;
        }
        String urlQuery = "";
        if (query != null && !query.isEmpty()) {
            urlQuery = "?search=" + this.urlencode(query);
        }
        return layer + urlQuery;
    }

    protected String prepareImport(String layer, Collection<String> tags) {
        String path = this.getEndpoint();
        if (layer != null && !layer.isEmpty()) {
            if (!(layer = Stream.of(layer.split("/")).map(this::urlencode).collect(Collectors.joining("/"))).endsWith("/")) {
                layer = layer + "/";
            }
            if (!layer.startsWith("/")) {
                layer = "/" + layer;
            }
            path = path + layer;
        }
        if (tags != null && !tags.isEmpty()) {
            path = path + "?tags=" + String.join((CharSequence)",", tags);
        }
        return path;
    }

    public WriteStream<Buffer> startImport(Handler<AsyncResult<Void>> handler) {
        return this.startImport(null, null, Optional.empty(), handler);
    }

    public WriteStream<Buffer> startImport(String layer, Handler<AsyncResult<Void>> handler) {
        return this.startImport(layer, null, Optional.empty(), handler);
    }

    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Handler<AsyncResult<Void>> handler) {
        return this.startImport(layer, tags, Optional.empty(), handler);
    }

    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, long size, Handler<AsyncResult<Void>> handler) {
        return this.startImport(layer, tags, Optional.of(size), handler);
    }

    public WriteStream<Buffer> startImport(String layer, Collection<String> tags, Optional<Long> size, Handler<AsyncResult<Void>> handler) {
        String path = this.prepareImport(layer, tags);
        HttpClientRequest request = this.client.post(path);
        if (size.isPresent() && size.get() != null) {
            request.putHeader("Content-Length", size.get().toString());
        } else {
            request.setChunked(true);
        }
        request.handler(response -> {
            if (response.statusCode() != 202) {
                handler.handle((Object)Future.failedFuture((String)("GeoRocket did not accept the file (status code " + response.statusCode() + ": " + response.statusMessage() + ")")));
            } else {
                handler.handle((Object)Future.succeededFuture());
            }
        });
        return this.configureRequest(request);
    }

    protected HttpClientRequest configureRequest(HttpClientRequest request) {
        return request;
    }

    public void search(Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        this.search(null, null, handler);
    }

    public void search(String query, Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        this.search(query, null, handler);
    }

    public void search(String query, String layer, Handler<AsyncResult<ReadStream<Buffer>>> handler) {
        String queryPath = this.prepareQuery(query, layer);
        HttpClientRequest request = this.client.get(this.getEndpoint() + queryPath);
        request.exceptionHandler(t -> handler.handle((Object)Future.failedFuture((Throwable)t)));
        request.handler(response -> {
            if (response.statusCode() == 404) {
                handler.handle((Object)Future.failedFuture((Throwable)new NoSuchElementException(response.statusMessage())));
            } else if (response.statusCode() != 200) {
                handler.handle((Object)Future.failedFuture((String)response.statusMessage()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)response));
            }
        });
        this.configureRequest(request).end();
    }

    public void delete(String query, Handler<AsyncResult<Void>> handler) {
        this.delete(query, null, handler);
    }

    public void delete(String query, String layer, Handler<AsyncResult<Void>> handler) {
        if ((query == null || query.isEmpty()) && (layer == null || layer.isEmpty())) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException("No search query and no layer given. Do you really wish to delete the whole data store? If so, provide an empty query and the root layer /.")));
        }
        String queryPath = this.prepareQuery(query, layer);
        HttpClientRequest request = this.client.delete(this.getEndpoint() + queryPath);
        request.exceptionHandler(t -> handler.handle((Object)Future.failedFuture((Throwable)t)));
        request.handler(response -> {
            if (response.statusCode() != 204) {
                handler.handle((Object)Future.failedFuture((String)response.statusMessage()));
            } else {
                response.endHandler(v -> handler.handle((Object)Future.succeededFuture()));
            }
        });
        this.configureRequest(request).end();
    }

    protected String getEndpoint() {
        return "/store";
    }
}

