/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.exception;

import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import io.evitadb.exception.EvitaError;
import io.evitadb.externalApi.graphql.exception.EvitaGraphQLError;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvitaDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(EvitaDataFetcherExceptionHandler.class);

    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@Nonnull DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable exception = this.unwrap(handlerParameters.getException());
        Object evitaError = exception instanceof EvitaError ? (EvitaError)exception : new GraphQLInternalError("Unexpected internal evitaDB GraphQL API error occurred: " + exception.getMessage(), "Unexpected internal evitaDB GraphQL API error occurred.", exception);
        if (evitaError instanceof GraphQLInternalError) {
            GraphQLInternalError graphQLInternalError = (GraphQLInternalError)((Object)evitaError);
            log.error("Internal evitaDB GraphQL API error occurred in {}: {}", new Object[]{graphQLInternalError.getErrorCode(), graphQLInternalError.getPrivateMessage(), graphQLInternalError});
        }
        EvitaGraphQLError error = new EvitaGraphQLError(evitaError.getPublicMessage(), handlerParameters.getSourceLocation(), handlerParameters.getPath().toList(), Map.of("errorCode", evitaError.getErrorCode()));
        return CompletableFuture.completedFuture(DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build());
    }

    protected Throwable unwrap(Throwable exception) {
        if (exception.getCause() != null && exception instanceof CompletionException) {
            return exception.getCause();
        }
        return exception;
    }
}

