/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.ArrayValue;
import graphql.language.NullValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.evitadb.dataType.Range;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RangeCoercing<E, R extends Range<E>, T>
implements Coercing<R, T[]> {
    protected abstract Class<R> getRangeClass();

    protected abstract Class<T> getTupleComponentClass();

    public T[] serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!this.getRangeClass().isAssignableFrom(dataFetcherResult.getClass())) {
            throw new CoercingSerializeException("Range data fetcher result is not a '" + this.getRangeClass().getName() + "'.");
        }
        try {
            Range range = (Range)dataFetcherResult;
            return this.createTuple(this.formatRangeEnd(range.getPreciseFrom()), this.formatRangeEnd(range.getPreciseTo()));
        }
        catch (DateTimeException ex) {
            throw new CoercingSerializeException((Throwable)ex);
        }
    }

    @Nonnull
    public R parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof Collection)) {
            throw new CoercingParseValueException("Range input value is not a tuple (array).");
        }
        Collection tuple = (Collection)input;
        if (tuple.size() != 2) {
            throw new CoercingParseValueException("Range input value is not a tuple with 2 items.");
        }
        try {
            Iterator tupleIterator = tuple.iterator();
            return this.createRange(this.parseRangeEnd(tupleIterator.next()), this.parseRangeEnd(tupleIterator.next()));
        }
        catch (RuntimeException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public R parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof ArrayValue)) {
            throw new CoercingParseLiteralException("Range input value is not a tuple (list).");
        }
        try {
            List items = ((ArrayValue)input).getChildren();
            if (items.size() != 2) {
                throw new CoercingParseLiteralException("Range input value is not a tuple with 2 items.");
            }
            return this.createRange(this.parseRangeEndNode(items.get(0)), this.parseRangeEndNode(items.get(1)));
        }
        catch (ArithmeticException | IllegalArgumentException | DateTimeParseException ex) {
            throw new CoercingParseLiteralException((Throwable)ex);
        }
    }

    @Nonnull
    protected abstract T[] createTuple(@Nullable T var1, @Nullable T var2);

    @Nonnull
    protected abstract R createRange(@Nullable E var1, @Nullable E var2);

    @Nonnull
    protected abstract T extractRangeEndFromNode(@Nonnull Object var1);

    @Nullable
    protected abstract T formatRangeEnd(@Nullable E var1);

    @Nullable
    protected abstract E parseRangeEnd(@Nullable T var1);

    @Nullable
    private E parseRangeEndNode(@Nullable Object endNode) {
        return Optional.ofNullable(endNode).map(i -> {
            if (i instanceof NullValue) {
                return null;
            }
            return this.parseRangeEnd(this.extractRangeEndFromNode(i));
        }).orElse(null);
    }
}

