/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.QueryUtils;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.EntityLocaleEquals;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.filter.PriceInCurrency;
import io.evitadb.api.query.filter.PriceInPriceLists;
import io.evitadb.api.query.filter.PriceValidIn;
import io.evitadb.api.query.head.Collection;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.catalog.dataApi.model.DataChunkDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ResponseDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.QueryEntitiesHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.AttributeHistogramResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FacetSummaryResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.HierarchyExtraResultRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.PagingRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.PriceHistogramResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.QueryTelemetryResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidResponseUsageException;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEntitiesDataFetcher
implements DataFetcher<DataFetcherResult<EvitaResponse<EntityClassifier>>> {
    private static final Logger log = LoggerFactory.getLogger(QueryEntitiesDataFetcher.class);
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final Map<String, EntitySchemaContract> referencedEntitySchemas;
    @Nonnull
    private final FilterConstraintResolver filterConstraintResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;
    @Nonnull
    private final RequireConstraintResolver requireConstraintResolver;
    @Nonnull
    private final PagingRequireResolver pagingRequireResolver;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;
    @Nonnull
    private final AttributeHistogramResolver attributeHistogramResolver;
    @Nonnull
    private final PriceHistogramResolver priceHistogramResolver;
    @Nonnull
    private final FacetSummaryResolver facetSummaryResolver;
    @Nonnull
    private final HierarchyExtraResultRequireResolver hierarchyExtraResultRequireResolver;
    @Nonnull
    private final QueryTelemetryResolver queryTelemetryResolver;

    @Nullable
    private static Locale extractDesiredLocale(@Nullable FilterBy filterBy) {
        return Optional.ofNullable(filterBy).map(it -> (EntityLocaleEquals)QueryUtils.findConstraint((Constraint)it, EntityLocaleEquals.class)).map(EntityLocaleEquals::getLocale).orElse(null);
    }

    public QueryEntitiesDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        this.entitySchema = entitySchema;
        this.referencedEntitySchemas = CollectionUtils.createHashMap((int)entitySchema.getReferences().size());
        entitySchema.getReferences().values().stream().filter(ReferenceSchemaContract::isReferencedEntityTypeManaged).forEach(referenceSchema -> {
            EntitySchemaContract referencedEntitySchema = catalogSchema.getEntitySchemaOrThrowException(referenceSchema.getReferencedEntityType());
            this.referencedEntitySchemas.put(referenceSchema.getName(), referencedEntitySchema);
        });
        this.filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        this.orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        this.requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(this.filterConstraintResolver));
        this.pagingRequireResolver = new PagingRequireResolver();
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), this.filterConstraintResolver, this.orderConstraintResolver, this.requireConstraintResolver);
        this.attributeHistogramResolver = new AttributeHistogramResolver(entitySchema);
        this.priceHistogramResolver = new PriceHistogramResolver();
        this.facetSummaryResolver = new FacetSummaryResolver(entitySchema, this.referencedEntitySchemas, this.entityFetchRequireResolver, this.filterConstraintResolver, this.orderConstraintResolver);
        this.hierarchyExtraResultRequireResolver = new HierarchyExtraResultRequireResolver(entitySchema, arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), this.entityFetchRequireResolver, this.orderConstraintResolver, this.requireConstraintResolver);
        this.queryTelemetryResolver = new QueryTelemetryResolver();
    }

    @Nonnull
    public DataFetcherResult<EvitaResponse<EntityClassifier>> get(@Nonnull DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment);
        FilterBy filterBy = this.buildFilterBy(arguments);
        OrderBy orderBy = this.buildOrderBy(arguments);
        Require require = this.buildRequire(environment, arguments, QueryEntitiesDataFetcher.extractDesiredLocale(filterBy));
        Query query = Query.query((Collection)QueryConstraints.collection((String)this.entitySchema.getName()), (FilterBy)filterBy, (OrderBy)orderBy, (Require)require);
        log.debug("Generated evitaDB query for entity query fetch of type `{}` is `{}`.", (Object)this.entitySchema.getName(), (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        EvitaResponse response = evitaSession.query(query, EntityClassifier.class);
        return DataFetcherResult.newResult().data((Object)response).localContext((Object)QueryEntitiesDataFetcher.buildResultContext(query)).build();
    }

    @Nullable
    private FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        if (arguments.filterBy() == null) {
            return null;
        }
        return (FilterBy)this.filterConstraintResolver.resolve(this.entitySchema.getName(), QueryEntitiesHeaderDescriptor.FILTER_BY.name(), arguments.filterBy());
    }

    @Nullable
    private OrderBy buildOrderBy(@Nonnull Arguments arguments) {
        if (arguments.orderBy() == null) {
            return null;
        }
        return (OrderBy)this.orderConstraintResolver.resolve(this.entitySchema.getName(), QueryEntitiesHeaderDescriptor.ORDER_BY.name(), arguments.orderBy());
    }

    @Nonnull
    private Require buildRequire(@Nonnull DataFetchingEnvironment environment, @Nonnull Arguments arguments, @Nullable Locale desiredLocale) {
        SelectionSetAggregator selectionSet;
        List<SelectedField> recordFields;
        Require explicitRequire;
        LinkedList<Object> requireConstraints = new LinkedList<Object>();
        if (arguments.require() != null && (explicitRequire = (Require)this.requireConstraintResolver.resolve(this.entitySchema.getName(), QueryEntitiesHeaderDescriptor.REQUIRE.name(), arguments.require())) != null) {
            requireConstraints.addAll(Arrays.asList((RequireConstraint[])explicitRequire.getChildren()));
        }
        Assert.isTrue(((recordFields = (selectionSet = SelectionSetAggregator.from(environment.getSelectionSet())).getImmediateFields(Set.of(ResponseDescriptor.RECORD_PAGE.name(), ResponseDescriptor.RECORD_STRIP.name()))).size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Entity response can have either `" + ResponseDescriptor.RECORD_PAGE.name() + "` or `" + ResponseDescriptor.RECORD_STRIP.name() + "`, not both."));
        if (recordFields.isEmpty()) {
            requireConstraints.add(QueryConstraints.strip((Integer)0, (Integer)0));
        } else {
            SelectedField recordField = recordFields.get(0);
            requireConstraints.add(this.pagingRequireResolver.resolve(recordField));
            List<SelectedField> recordData = SelectionSetAggregator.getImmediateFields(DataChunkDescriptor.DATA.name(), recordField.getSelectionSet());
            if (!recordData.isEmpty()) {
                SelectionSetAggregator selectionSetAggregator = SelectionSetAggregator.from(recordData.stream().map(SelectedField::getSelectionSet).toList());
                Optional<EntityFetch> entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(selectionSetAggregator, desiredLocale, this.entitySchema);
                entityFetch.ifPresent(requireConstraints::add);
            }
        }
        List<SelectedField> extraResults = selectionSet.getImmediateFields(ResponseDescriptor.EXTRA_RESULTS.name());
        SelectionSetAggregator extraResultsSelectionSet = SelectionSetAggregator.from(extraResults.stream().map(SelectedField::getSelectionSet).toList());
        requireConstraints.addAll(this.attributeHistogramResolver.resolve(extraResultsSelectionSet));
        requireConstraints.add(this.priceHistogramResolver.resolve(extraResultsSelectionSet).orElse(null));
        requireConstraints.addAll(this.facetSummaryResolver.resolve(extraResultsSelectionSet, desiredLocale));
        requireConstraints.addAll(this.hierarchyExtraResultRequireResolver.resolve(extraResultsSelectionSet, desiredLocale));
        requireConstraints.add(this.queryTelemetryResolver.resolve(extraResultsSelectionSet).orElse(null));
        return QueryConstraints.require((RequireConstraint[])((RequireConstraint[])requireConstraints.toArray(RequireConstraint[]::new)));
    }

    @Nonnull
    private static EntityQueryContext buildResultContext(@Nonnull Query query) {
        Locale desiredLocale = Optional.ofNullable((EntityLocaleEquals)QueryUtils.findFilter((Query)query, EntityLocaleEquals.class)).map(EntityLocaleEquals::getLocale).orElse(null);
        Currency desiredPriceInCurrency = Optional.ofNullable((PriceInCurrency)QueryUtils.findFilter((Query)query, PriceInCurrency.class)).map(PriceInCurrency::getCurrency).orElse(null);
        Optional<PriceValidIn> priceValidInConstraint = Optional.ofNullable((PriceValidIn)QueryUtils.findFilter((Query)query, PriceValidIn.class));
        OffsetDateTime desiredPriceValidIn = priceValidInConstraint.map(it -> it.getTheMoment(() -> OffsetDateTime.MIN)).orElse(null);
        String[] desiredPriceInPriceLists = Optional.ofNullable((PriceInPriceLists)QueryUtils.findFilter((Query)query, PriceInPriceLists.class)).map(PriceInPriceLists::getPriceLists).orElse(null);
        return new EntityQueryContext(desiredLocale, desiredPriceInCurrency, desiredPriceInPriceLists, desiredPriceValidIn == OffsetDateTime.MIN ? null : desiredPriceValidIn, desiredPriceValidIn == OffsetDateTime.MIN);
    }

    private record Arguments(@Nullable Object filterBy, @Nullable Object orderBy, @Nullable Object require) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment) {
            Object filterBy = environment.getArgument(QueryEntitiesHeaderDescriptor.FILTER_BY.name());
            Object orderBy = environment.getArgument(QueryEntitiesHeaderDescriptor.ORDER_BY.name());
            Object require = environment.getArgument(QueryEntitiesHeaderDescriptor.REQUIRE.name());
            return new Arguments(filterBy, orderBy, require);
        }
    }
}

