/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.dto;

import io.evitadb.dataType.EvitaDataTypes;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormattableBigDecimal {
    @Nonnull
    private final BigDecimal value;
    @Nullable
    private final Locale formatLocale;

    public boolean isShouldFormat() {
        return this.formatLocale != null;
    }

    @Nonnull
    public String toFormattedString() {
        if (!this.isShouldFormat()) {
            return EvitaDataTypes.formatValue((Serializable)this.getValue());
        }
        return NumberFormat.getNumberInstance(this.getFormatLocale()).format(this.getValue());
    }

    public FormattableBigDecimal(@Nonnull BigDecimal value, @Nullable Locale formatLocale) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
        this.formatLocale = formatLocale;
    }

    @Nonnull
    public BigDecimal getValue() {
        return this.value;
    }

    @Nullable
    public Locale getFormatLocale() {
        return this.formatLocale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormattableBigDecimal)) {
            return false;
        }
        FormattableBigDecimal other = (FormattableBigDecimal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$value = this.getValue();
        BigDecimal other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Locale this$formatLocale = this.getFormatLocale();
        Locale other$formatLocale = other.getFormatLocale();
        return !(this$formatLocale == null ? other$formatLocale != null : !((Object)this$formatLocale).equals(other$formatLocale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormattableBigDecimal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Locale $formatLocale = this.getFormatLocale();
        result = result * 59 + ($formatLocale == null ? 43 : ((Object)$formatLocale).hashCode());
        return result;
    }

    public String toString() {
        return "FormattableBigDecimal(value=" + this.getValue() + ", formatLocale=" + this.getFormatLocale() + ")";
    }
}

