/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.descriptor.ConstraintDescriptor;
import io.evitadb.api.query.descriptor.ConstraintDescriptorProvider;
import io.evitadb.api.query.descriptor.ConstraintType;
import io.evitadb.api.query.require.FacetGroupsConjunction;
import io.evitadb.api.query.require.FacetGroupsDisjunction;
import io.evitadb.api.query.require.FacetGroupsNegation;
import io.evitadb.api.query.require.PriceType;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ConstraintSchemaBuilder;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.GenericDataLocator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.FilterConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.GraphQLConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.GraphQLConstraintSchemaBuildingContext;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class RequireConstraintSchemaBuilder
extends GraphQLConstraintSchemaBuilder {
    private static final Set<Class<? extends Constraint<?>>> MAIN_REQUIRE_ALLOWED_CONSTRAINTS = Set.of(FacetGroupsConjunction.class, FacetGroupsDisjunction.class, FacetGroupsNegation.class, PriceType.class);

    protected RequireConstraintSchemaBuilder(@Nonnull GraphQLConstraintSchemaBuildingContext sharedContext, @Nonnull Map<ConstraintType, AtomicReference<? extends ConstraintSchemaBuilder<GraphQLConstraintSchemaBuildingContext, GraphQLInputType, GraphQLInputType, GraphQLInputObjectField>>> additionalBuilders, @Nonnull Set<Class<? extends Constraint<?>>> allowedConstraints) {
        super(sharedContext, additionalBuilders, allowedConstraints, Set.of());
    }

    public static RequireConstraintSchemaBuilder forMainRequire(@Nonnull GraphQLConstraintSchemaBuildingContext sharedContext, @Nonnull AtomicReference<FilterConstraintSchemaBuilder> filterConstraintSchemaBuilder) {
        return new RequireConstraintSchemaBuilder(sharedContext, Map.of(ConstraintType.FILTER, filterConstraintSchemaBuilder), MAIN_REQUIRE_ALLOWED_CONSTRAINTS);
    }

    public static RequireConstraintSchemaBuilder forHierarchyRequire(@Nonnull GraphQLConstraintSchemaBuildingContext sharedContext, @Nonnull AtomicReference<FilterConstraintSchemaBuilder> filterConstraintSchemaBuilder) {
        return new RequireConstraintSchemaBuilder(sharedContext, Map.of(ConstraintType.FILTER, filterConstraintSchemaBuilder), Set.of());
    }

    public static RequireConstraintSchemaBuilder forExtraResultsRequire(@Nonnull GraphQLConstraintSchemaBuildingContext sharedContext, @Nonnull AtomicReference<FilterConstraintSchemaBuilder> filterConstraintSchemaBuilder) {
        return new RequireConstraintSchemaBuilder(sharedContext, Map.of(ConstraintType.FILTER, filterConstraintSchemaBuilder), Set.of());
    }

    @Nonnull
    public GraphQLInputType build(@Nonnull String rootEntityType) {
        return (GraphQLInputType)this.build((DataLocator)new GenericDataLocator(rootEntityType));
    }

    @Nonnull
    protected ConstraintType getConstraintType() {
        return ConstraintType.REQUIRE;
    }

    @Nonnull
    protected ConstraintDescriptor getDefaultRootConstraintContainerDescriptor() {
        return ConstraintDescriptorProvider.getConstraint(Require.class);
    }

    @Nonnull
    protected String getContainerObjectTypeName() {
        return "RequireContainer";
    }

    @Nonnull
    protected Predicate<AttributeSchemaContract> getAttributeSchemaFilter() {
        return attributeSchema -> true;
    }
}

