/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog;

import graphql.GraphQL;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import io.evitadb.api.CatalogContract;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.graphql.api.GraphQLBuilder;
import io.evitadb.externalApi.graphql.api.catalog.EvitaSessionManagingInstrumentation;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.graphql.exception.EvitaDataFetcherExceptionHandler;
import javax.annotation.Nonnull;

public class CatalogGraphQLBuilder
implements GraphQLBuilder {
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final CatalogContract catalog;
    @Nonnull
    private final GraphQLSchema graphQLSchema;

    @Override
    public GraphQL build(@Nonnull GraphQLConfig config) {
        EvitaSessionManagingInstrumentation instrumentation = new EvitaSessionManagingInstrumentation(this.evita, this.catalog.getName());
        EvitaDataFetcherExceptionHandler dataFetcherExceptionHandler = new EvitaDataFetcherExceptionHandler();
        return GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema).instrumentation((Instrumentation)instrumentation).defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)dataFetcherExceptionHandler).build();
    }

    public CatalogGraphQLBuilder(@Nonnull Evita evita, @Nonnull CatalogContract catalog, @Nonnull GraphQLSchema graphQLSchema) {
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        if (catalog == null) {
            throw new NullPointerException("catalog is marked non-null but is null");
        }
        if (graphQLSchema == null) {
            throw new NullPointerException("graphQLSchema is marked non-null but is null");
        }
        this.evita = evita;
        this.catalog = catalog;
        this.graphQLSchema = graphQLSchema;
    }
}

