/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.redis.topic;

import io.ebean.redis.topic.DaemonTopic;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public final class DaemonTopicRunner {
    private static final Logger log = LoggerFactory.getLogger(DaemonTopicRunner.class);
    private static final long reconnectWaitMillis = 1000L;
    private final JedisPool jedisPool;
    private final DaemonTopic daemonTopic;

    public DaemonTopicRunner(JedisPool jedisPool, DaemonTopic daemonTopic) {
        this.jedisPool = jedisPool;
        this.daemonTopic = daemonTopic;
    }

    public void run() {
        new Thread(this::attemptConnections, "redis-sub").start();
    }

    private void attemptConnections() {
        Timer reloadTimer = new Timer("redis-sub-notify");
        TimerTask notifyTask = null;
        int attempts = 1;
        while (true) {
            if (notifyTask != null) {
                notifyTask.cancel();
            }
            notifyTask = new ReloadNotifyTask();
            reloadTimer.schedule(notifyTask, 1500L);
            ++attempts;
            try {
                this.subscribe();
                continue;
            }
            catch (JedisException e) {
                log.debug("... redis subscribe connection attempt:{} failed:{}", (Object)attempts, (Object)e.getMessage());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted redis re-connection wait", (Throwable)e1);
                    continue;
                }
            }
            break;
        }
    }

    private void subscribe() {
        Jedis jedis = this.jedisPool.getResource();
        jedis.echo("hi");
        try {
            this.daemonTopic.subscribe(jedis);
        }
        catch (Exception e) {
            log.error("Lost connection to topic, starting re-connection loop", (Throwable)e);
            this.attemptConnections();
        }
        finally {
            try {
                jedis.close();
            }
            catch (Exception e) {
                log.warn("Error closing probably broken Redis connection", (Throwable)e);
            }
        }
    }

    private class ReloadNotifyTask
    extends TimerTask {
        private ReloadNotifyTask() {
        }

        @Override
        public void run() {
            DaemonTopicRunner.this.daemonTopic.notifyConnected();
        }
    }
}

