/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons.service;

import io.docops.asciidoc.buttons.ButtonRenderImpl;
import io.docops.asciidoc.buttons.dsl.ButtonItem;
import io.docops.asciidoc.buttons.dsl.LargeButton;
import io.docops.asciidoc.buttons.dsl.PanelButton;
import io.docops.asciidoc.buttons.dsl.Panels;
import io.docops.asciidoc.buttons.dsl.RoundButton;
import io.docops.asciidoc.buttons.dsl.SlimButton;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.ButtonType;
import io.docops.asciidoc.buttons.theme.Theme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lio/docops/asciidoc/buttons/service/PanelService;", "", "()V", "fromPanelToSvg", "", "panel", "Lio/docops/asciidoc/buttons/dsl/Panels;", "toLines", "", "filename", "panels", "toPanelForPdfLinks", "Lio/docops/asciidoc/buttons/dsl/ButtonItem;", "docops.button-render"})
public final class PanelService {
    @NotNull
    public final String fromPanelToSvg(@NotNull Panels panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Theme theme = new Theme();
        theme.setType(panel.getButtonType());
        theme.setGroupBy(panel.getButtonTheme().getLayout().getGroupBy());
        theme.setGroupOrder(panel.getButtonTheme().getLayout().getGroupOrder());
        theme.setColumns(panel.getButtonTheme().getLayout().getColumns());
        if (!((Collection)panel.getButtonTheme().getColorMap().getColors()).isEmpty()) {
            theme.setColorMap(panel.getButtonTheme().getColorMap().getColors());
        }
        theme.setDefs(panel.getButtonTheme().getColorMap().getColorDefs());
        theme.setPDF(panel.isPdf());
        theme.setLegendOn(panel.getButtonTheme().getLegendOn());
        theme.setNewWin(panel.getButtonTheme().getNewWin());
        List localList = new ArrayList();
        ButtonRenderImpl b = new ButtonRenderImpl();
        switch (WhenMappings.$EnumSwitchMapping$0[panel.getButtonType().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = panel.getPanelButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PanelButton it = (PanelButton)element$iv;
                    boolean bl = false;
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), new ArrayList(), it.getLabel(), "", panel.getButtonTheme().getFont().getColor(), null, null, 384, null);
                    localList.add(btn);
                }
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = panel.getSlimButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SlimButton it = (SlimButton)element$iv;
                    boolean bl = false;
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), it.getAuthors(), it.getType(), it.getDate(), panel.getButtonTheme().getFont().getColor(), null, null, 384, null);
                    localList.add(btn);
                }
                break;
            }
            case 3: {
                Iterable $this$forEach$iv = panel.getLargeButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LargeButton it = (LargeButton)element$iv;
                    boolean bl = false;
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), new ArrayList(), it.getType(), it.getDate(), panel.getButtonTheme().getFont().getColor(), null, null, 384, null);
                    localList.add(btn);
                }
                break;
            }
            case 4: {
                Iterable $this$forEach$iv = panel.getRoundButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RoundButton it = (RoundButton)element$iv;
                    boolean bl = false;
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), new ArrayList(), it.getLabel(), "", panel.getButtonTheme().getFont().getColor(), null, null, 384, null);
                    localList.add(btn);
                }
                break;
            }
        }
        return b.render(localList, theme);
    }

    @NotNull
    public final List<String> toLines(@NotNull String filename, @NotNull Panels panels) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)panels, (String)"panels");
        List lines = new ArrayList();
        lines.add(Intrinsics.stringPlus((String)".", (Object)filename));
        lines.add("[options=header]");
        lines.add("|===");
        lines.add("|Label |Link");
        List<ButtonItem> buttons = this.toPanelForPdfLinks(panels);
        Iterable $this$forEach$iv = buttons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ButtonItem it = (ButtonItem)element$iv;
            boolean bl = false;
            lines.add("a|" + it.getLabel() + " | " + it.getLink());
        }
        lines.add("|===");
        return lines;
    }

    private final List<ButtonItem> toPanelForPdfLinks(Panels panel) {
        List localList = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$0[panel.getButtonType().ordinal()]) {
            case 1: {
                localList.addAll((Collection)panel.getPanelButtons());
                break;
            }
            case 2: {
                localList.addAll((Collection)panel.getSlimButtons());
                break;
            }
            case 3: {
                localList.addAll((Collection)panel.getLargeButtons());
                break;
            }
            case 4: {
                localList.addAll((Collection)panel.getRoundButtons());
            }
        }
        return localList;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ButtonType.values().length];
            nArray[ButtonType.BUTTON.ordinal()] = 1;
            nArray[ButtonType.SLIM_CARD.ordinal()] = 2;
            nArray[ButtonType.LARGE_CARD.ordinal()] = 3;
            nArray[ButtonType.ROUND.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

