/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.ButtonMaker;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.models.ButtonKt;
import io.docops.asciidoc.buttons.theme.Theme;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lio/docops/asciidoc/buttons/SlimCardRenderer;", "Lio/docops/asciidoc/buttons/ButtonMaker;", "()V", "drawButtonRow", "", "rowCount", "", "row", "", "Lio/docops/asciidoc/buttons/models/Button;", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "drawButtons", "buttonList", "makeButtons", "buttons", "makeStyles", "docops.button-render"})
public final class SlimCardRenderer
extends ButtonMaker {
    @Override
    @NotNull
    public String makeButtons(@NotNull List<List<Button>> buttons, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        StringBuilder sb = new StringBuilder(this.makeSvgHead(buttons, 170, 250, 150, theme));
        sb.append(this.makeDefs(theme));
        sb.append(this.makeStyles());
        sb.append(this.drawButtons(buttons, theme));
        if (theme.getLegendOn()) {
            sb.append(this.drawLegend(this.getTypes()));
        }
        sb.append(this.makeSvgEnd());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtons(List<List<Button>> buttonList, Theme theme) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = buttonList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void buttons;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            sb.append(this.drawButtonRow(index, (List<Button>)buttons, theme));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtonRow(int rowCount, List<Button> row, Theme theme) {
        StringBuilder sb = new StringBuilder("<g>");
        int recXpos = 0;
        recXpos = 10;
        int yPos = 0;
        yPos = 10;
        int dateXpos = 0;
        dateXpos = 95;
        if (rowCount > 0) {
            yPos = rowCount * 160 + 10;
        }
        Iterable $this$forEachIndexed$iv = row;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void button;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Button button2 = (Button)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                recXpos += 160;
                dateXpos += 160;
            }
            String win = "_blank";
            if (!theme.getNewWin()) {
                win = "_top";
            }
            if (theme.isPDF()) {
                sb.append(StringsKt.trimIndent((String)("\n                   <use x=\"" + recXpos + "\" y=\"" + yPos + "\" fill=\"" + theme.buttonColor((Button)button) + "\" xlink:href=\"#mySlimRect\"> \n                       <title class=\"description\">" + ButtonKt.escapeXml(button.getDescription()) + "</title>\n                   </use>     \n                ")));
            } else {
                sb.append(StringsKt.trimIndent((String)("\n                    <a xlink:href=\"" + button.getLink() + "\" target=\"" + win + "\">\n                   <use x=\"" + recXpos + "\" y=\"" + yPos + "\" fill=\"" + theme.buttonColor((Button)button) + "\" xlink:href=\"#mySlimRect\"> \n                       <title class=\"description\">" + ButtonKt.escapeXml(button.getDescription()) + "</title>\n                   </use>    \n                   </a>\n                ")));
            }
            StringBuilder authors = new StringBuilder();
            int dy = button.getAuthors().size() == 0 ? 80 : 80 - button.getAuthors().size() * 16 + 16;
            Iterable $this$forEach$iv = button.getAuthors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                authors.append("<tspan x=\"" + (recXpos + 4) + "\" dy=\"16\" class=\"author\">" + ButtonKt.escapeXml(it) + "</tspan>");
            }
            sb.append(StringsKt.trimIndent((String)("\n                <text x=\"" + (recXpos + 2) + "\" y=\"" + (yPos + 20) + "\">\n                    <tspan x=\"" + (recXpos + 4) + "\" dy=\"0\" class=\"lineHead\">" + ButtonKt.escapeXml(button.getType()) + "</tspan>\n                    <tspan x=\"" + (recXpos + 4) + "\" dy=\"16\" class=\"subtitle\">" + ButtonKt.escapeXml(button.getTitle()) + "</tspan>\n                    " + authors + "\n                    <tspan x=\"" + dateXpos + "\" dy=\"" + dy + "\" class=\"date\">" + ButtonKt.escapeXml(button.getDate()) + "</tspan>\n                </text>\n            ")));
        }
        sb.append("</g>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String makeStyles() {
        return "        <style>\n    rect.card {\n        pointer-events: bounding-box;\n        opacity: 1;\n    }\n\n    rect.card:hover {\n        opacity: 0.6;\n    }\n\n    .card {\n        filter: url(#dropShadow);\n    }\n\n    .lineHead {\n        fill: white;\n        font-family: \"Noto Sans\",sans-serif;\n        font-weight: bold;\n        font-size: 12px;\n    }\n\n    .subtitle {\n        fill: white;\n        font-family: \"Noto Sans\",sans-serif;\n        font-weight: normal;\n        font-size: 10px;\n    }\n\n    .author {\n        fill: black;\n        font-family: \"Noto Sans\",sans-serif;\n        font-weight: normal;\n        font-size: 10px;\n    }\n\n    .date {\n        fill: white;\n        font-family: \"Noto Sans\",sans-serif;\n        font-weight: normal;\n        font-size: 10px;\n    }\n    #tooltip {\n        background: cornsilk;\n        border: 1px solid black;\n        border-radius: 5px;\n        padding: 5px;\n    }\n</style>";
    }
}

