/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.boot.redis;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.session.engine.DialobProgramService;
import io.dialob.session.engine.program.DialobSessionEvalContextFactory;
import io.dialob.session.engine.sp.AsyncFunctionInvoker;
import io.dialob.session.engine.sp.DialobQuestionnaireSession;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.noop.NoopTimer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.lang.Nullable;

public class QuestionnaireDialobSessionRedisSerializer
implements RedisSerializer<DialobQuestionnaireSession> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionnaireDialobSessionRedisSerializer.class);
    private final QuestionnaireEventPublisher eventPublisher;
    private final DialobProgramService dialobProgramService;
    private final DialobSessionEvalContextFactory sessionContextFactory;
    private final AsyncFunctionInvoker asyncFunctionInvoker;
    private final Timer serializationTimer;
    private final Timer deserializationTimer;
    private final int bufferSize;

    public QuestionnaireDialobSessionRedisSerializer(QuestionnaireEventPublisher eventPublisher, DialobProgramService dialobProgramService, DialobSessionEvalContextFactory sessionContextFactory, AsyncFunctionInvoker asyncFunctionInvoker, @NonNull Optional<MeterRegistry> meterRegistry, int bufferSize) {
        this.eventPublisher = eventPublisher;
        this.dialobProgramService = dialobProgramService;
        this.sessionContextFactory = sessionContextFactory;
        this.asyncFunctionInvoker = asyncFunctionInvoker;
        NoopTimer noopTimer = new NoopTimer(null);
        this.serializationTimer = meterRegistry.map(registry -> Timer.builder((String)"session.serialization.time").register(registry)).orElse((Timer)noopTimer);
        this.deserializationTimer = meterRegistry.map(registry -> Timer.builder((String)"session.deserialization.time").register(registry)).orElse((Timer)noopTimer);
        this.bufferSize = bufferSize;
    }

    public byte[] serialize(@Nullable DialobQuestionnaireSession dialobQuestionnaireSession) {
        if (dialobQuestionnaireSession == null) {
            return null;
        }
        return (byte[])this.serializationTimer.record(() -> {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.bufferSize);
            CodedOutputStream output = CodedOutputStream.newInstance((ByteBuffer)byteBuffer);
            try {
                dialobQuestionnaireSession.writeTo(output);
                output.flush();
            }
            catch (IOException e) {
                throw new SerializationException("ProtoBuf serialization failed. Session " + String.valueOf(dialobQuestionnaireSession.getSessionId()), (Throwable)e);
            }
            int totalBytesWritten = output.getTotalBytesWritten();
            LOGGER.trace("serialized {} to redis into {} bytes", (Object)dialobQuestionnaireSession.getSessionId(), (Object)totalBytesWritten);
            return Arrays.copyOf(byteBuffer.array(), totalBytesWritten);
        });
    }

    public DialobQuestionnaireSession deserialize(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        LOGGER.trace("deserialize from redis {} bytes", (Object)bytes.length);
        return (DialobQuestionnaireSession)this.deserializationTimer.record(() -> {
            CodedInputStream input = CodedInputStream.newInstance((byte[])bytes);
            try {
                return this.restoreSessionFrom(input);
            }
            catch (IOException e) {
                throw new SerializationException("ProtoBuf deserialization failed", (Throwable)e);
            }
        });
    }

    @NonNull
    protected DialobQuestionnaireSession restoreSessionFrom(@NonNull CodedInputStream input) throws IOException {
        DialobQuestionnaireSession.Builder builder = DialobQuestionnaireSession.builder().eventPublisher(this.eventPublisher).sessionContextFactory(this.sessionContextFactory).asyncFunctionInvoker(this.asyncFunctionInvoker).readFrom(input);
        Questionnaire.Metadata metadata = builder.getMetadata();
        return builder.dialobProgram(this.dialobProgramService.findByFormIdAndRev(metadata.getFormId(), metadata.getFormRev())).build();
    }
}

