/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.sp;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ActionsFactory;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActionItem;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.api.proto.ImmutableValueSet;
import io.dialob.api.proto.ImmutableValueSetEntry;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableAnswer;
import io.dialob.api.questionnaire.ImmutableContextValue;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.ImmutableVariableValue;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import io.dialob.questionnaire.service.api.FormActions;
import io.dialob.questionnaire.service.api.FormActionsUpdatesCallback;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.ImmutableQuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.utils.ConversionUtil;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.FormActionsUpdatesItemsVisitor;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.DialobSessionEvalContextFactory;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.DisplayItem;
import io.dialob.session.engine.session.ActionToCommandMapper;
import io.dialob.session.engine.session.DialobSessionUpdater;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.DialobSessionVisitor;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.SessionObject;
import io.dialob.session.engine.session.model.ValueSetState;
import io.dialob.session.engine.sp.AsyncFunctionInvoker;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DialobQuestionnaireSession
implements QuestionnaireSession {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobQuestionnaireSession.class);
    private final String rev;
    private final DialobSession dialobSession;
    private final DialobProgram dialobProgram;
    private final QuestionnaireSession.QuestionClientVisibility questionClientVisibility;
    private final AtomicReference<State> state;
    private final Questionnaire.Metadata metadata;
    private final transient QuestionnaireEventPublisher eventPublisher;
    private final transient DialobSessionEvalContextFactory sessionContextFactory;
    private final transient AsyncFunctionInvoker asyncFunctionInvoker;
    private final transient Function<ItemState, ActionItem> toActionItemFunction;

    private DialobQuestionnaireSession(String rev, @NonNull DialobSession dialobSession, @NonNull DialobQuestionnaireSession dialobQuestionnaireSession) {
        this(dialobQuestionnaireSession.eventPublisher, dialobQuestionnaireSession.sessionContextFactory, dialobQuestionnaireSession.asyncFunctionInvoker, dialobSession, dialobQuestionnaireSession.dialobProgram, rev, dialobQuestionnaireSession.metadata, dialobQuestionnaireSession.state.get(), dialobQuestionnaireSession.questionClientVisibility);
    }

    private DialobQuestionnaireSession(@NonNull QuestionnaireEventPublisher eventPublisher, @NonNull DialobSessionEvalContextFactory sessionContextFactory, @NonNull AsyncFunctionInvoker asyncFunctionInvoker, @NonNull DialobSession dialobSession, @NonNull DialobProgram dialobProgram, String rev, @NonNull Questionnaire.Metadata metadata, @NonNull State state, @NonNull QuestionnaireSession.QuestionClientVisibility questionClientVisibility) {
        this.rev = rev;
        this.metadata = metadata;
        this.eventPublisher = eventPublisher;
        this.sessionContextFactory = sessionContextFactory;
        this.asyncFunctionInvoker = asyncFunctionInvoker;
        this.dialobSession = Objects.requireNonNull(dialobSession, "dialobSession may not be null");
        this.dialobProgram = dialobProgram;
        this.questionClientVisibility = questionClientVisibility;
        this.state = new AtomicReference<State>(state);
        this.toActionItemFunction = itemState -> Utils.toActionItem(itemState, builder -> {
            if (itemState.hasCustomProps()) {
                ItemId id = itemState.getPrototypeId();
                if (id == null) {
                    id = itemState.getId();
                }
                dialobProgram.getItem(id).filter(item -> item instanceof DisplayItem).map(item -> ((DisplayItem)item).getProps()).ifPresent(arg_0 -> ((ImmutableActionItem.Builder)builder).props(arg_0));
            }
            return builder;
        });
    }

    public QuestionnaireSession withIdAndRev(String id, String rev) {
        return new DialobQuestionnaireSession(rev, this.dialobSession.withId(id), this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(@NonNull CodedOutputStream output) throws IOException {
        Utils.writeNullableString(output, this.rev);
        output.writeInt32NoTag(this.questionClientVisibility.ordinal());
        output.writeInt32NoTag(this.state.get().ordinal());
        output.writeStringNoTag(this.metadata.getStatus().name());
        output.writeStringNoTag(this.metadata.getFormId());
        Utils.writeNullableString(output, this.metadata.getFormRev());
        Utils.writeNullableString(output, this.metadata.getLanguage());
        Utils.writeNullableString(output, this.metadata.getLabel());
        Utils.writeNullableDate(output, this.metadata.getCreated());
        Utils.writeNullableDate(output, this.metadata.getLastAnswer());
        Utils.writeNullableString(output, this.metadata.getCreator());
        Utils.writeNullableString(output, this.metadata.getOwner());
        Utils.writeNullableString(output, this.metadata.getTenantId());
        Utils.writeNullableString(output, this.metadata.getSubmitUrl());
        output.writeInt32NoTag(this.metadata.getAdditionalProperties().size());
        for (Map.Entry entry : this.metadata.getAdditionalProperties().entrySet()) {
            output.writeStringNoTag((String)entry.getKey());
            Utils.writeObjectValue(output, entry.getValue());
        }
        this.dialobSession.writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public QuestionnaireSession.DispatchActionsResult dispatchActions(String revision, @NonNull Collection<Action> actions) {
        final ImmutableQuestionnaireSession.DispatchActionsResult.Builder actionsResultBuilder = ImmutableQuestionnaireSession.DispatchActionsResult.builder().isDidComplete(false);
        String prevRevision = this.dialobSession.getRevision();
        if (this.isCompleted()) {
            return actionsResultBuilder.actions((Actions)ImmutableActions.builder().rev(prevRevision).build()).build();
        }
        try {
            ImmutableQuestionnaireSession.DispatchActionsResult actionsResult;
            List broadcastActions;
            MDC.put((String)"questionnaire", (String)this.getSessionId().orElse("new-session"));
            boolean revisionMatch = revision != null && revision.equals(prevRevision);
            LOGGER.debug("revision comparison: {} vs. {} == {}", new Object[]{revision, prevRevision, revisionMatch});
            DialobSessionUpdater sessionUpdater = this.sessionContextFactory.createSessionUpdater(this.dialobProgram, this.dialobSession, this.state.get() == State.ACTIVATING);
            FormActions formActions = new FormActions();
            List<Command<?>> commands = ActionToCommandMapper.toCommands(actions);
            sessionUpdater.applyCommands(commands).accept(new EvalContext.AbstractDelegateUpdatedItemsVisitor(new FormActionsUpdatesItemsVisitor(formActions, this.getIsVisiblePredicate(), this.toActionItemFunction)){

                @Override
                public void visitCompleted() {
                    super.visitCompleted();
                    actionsResultBuilder.isDidComplete(true);
                }

                @Override
                public Optional<EvalContext.UpdatedItemsVisitor.AsyncFunctionCallVisitor> visitAsyncFunctionCalls() {
                    return DialobQuestionnaireSession.this.getSessionId().map(DialobQuestionnaireSession.this.asyncFunctionInvoker::createVisitor);
                }
            });
            if (!revisionMatch) {
                formActions.clear();
                this.buildFullForm((QuestionnaireSession.UpdatesCallback)new FormActionsUpdatesCallback(formActions));
                broadcastActions = formActions.getActions();
            } else {
                broadcastActions = Stream.concat(actions.stream().filter(action -> action.getType().isClientAction()), formActions.getActions().stream()).toList();
            }
            String newRevision = this.dialobSession.getRevision();
            if (!broadcastActions.isEmpty() && this.isActive()) {
                this.publishQuestionnaireActions(newRevision, broadcastActions);
            }
            if ((actionsResult = actionsResultBuilder.actions((Actions)ImmutableActions.builder().actions((Iterable)formActions.getActions()).rev(newRevision).build()).build()).isDidComplete()) {
                this.getSessionId().ifPresent(sessionId -> this.eventPublisher.completed(this.getDialobSession().getTenantId(), sessionId));
            }
            ImmutableQuestionnaireSession.DispatchActionsResult dispatchActionsResult = actionsResult;
            return dispatchActionsResult;
        }
        finally {
            MDC.remove((String)"questionnaire");
        }
    }

    @NonNull
    public QuestionnaireSession.DispatchActionsResult dispatchActions(@NonNull Collection<Action> actions) {
        return this.dispatchActions(this.dialobSession.getRevision(), actions);
    }

    @NonNull
    public Questionnaire getQuestionnaire() {
        return ImmutableQuestionnaire.builder().id(this.dialobSession.getId()).rev(this.rev).context(this.getContextVariableValues()).answers(this.getAnswers()).errors(this.getErrors()).variableValues(this.getVariableValues()).activeItem((String)this.getActiveItem().orElse(null)).valueSets(this.getProvidedValueSets()).metadata(this.getQuestionnaireMetadata()).activeItems(this.getActiveItems()).build();
    }

    @NonNull
    public Questionnaire.Metadata getQuestionnaireMetadata() {
        Questionnaire.Metadata.Status status;
        if (this.dialobSession.isCompleted()) {
            status = Questionnaire.Metadata.Status.COMPLETED;
        } else {
            status = switch (this.state.get().ordinal()) {
                case 0, 1 -> Questionnaire.Metadata.Status.NEW;
                default -> Questionnaire.Metadata.Status.OPEN;
            };
        }
        return ImmutableQuestionnaireMetadata.builder().from(this.metadata).lastAnswer(Date.from(this.dialobSession.getLastUpdate())).completed(this.dialobSession.getCompleted() != null ? Date.from(this.dialobSession.getCompleted()) : null).opened(this.dialobSession.getOpened() != null ? Date.from(this.dialobSession.getOpened()) : null).status(status).language(this.dialobSession.getLanguage()).tenantId(this.dialobSession.getTenantId()).build();
    }

    private Iterable<? extends ValueSet> getProvidedValueSets() {
        return () -> this.dialobSession.getValueSetStates().values().stream().map(state -> ImmutableValueSet.builder().id(state.getId().getValueSetId()).entries(() -> state.getEntries().stream().filter(ValueSetState.Entry::isProvided).map(entry -> ImmutableValueSetEntry.builder().key(entry.getId()).value(entry.getLabel()).build()).iterator()).build()).iterator();
    }

    private Iterable<? extends ContextValue> getContextVariableValues() {
        final ArrayList answers = new ArrayList();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (Utils.isContextVariable(itemState.getType())) {
                        Object value = ConversionUtil.toJSON((Object)itemState.getValue());
                        answers.add(ImmutableContextValue.builder().id(IdUtils.toString(itemState.getId())).value((Object)(value == null ? null : value.toString())).build());
                    }
                });
            }
        });
        return answers;
    }

    @NonNull
    public String getRevision() {
        return this.dialobSession.getRevision();
    }

    public String getId() {
        return this.dialobSession.getId();
    }

    public String getRev() {
        return this.rev;
    }

    @Nullable
    public String getOwner() {
        return this.metadata.getOwner();
    }

    @NonNull
    public Instant getLastUpdate() {
        return this.dialobSession.getLastUpdate();
    }

    public Optional<String> getActiveItem() {
        return this.dialobSession.getRootItem().getActivePage().map(IdUtils::toString);
    }

    @NonNull
    public List<ValueSet> getValueSets() {
        final ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ValueSetVisitor> visitValueSetStates() {
                return Optional.of(valueSetState -> valueSets.add(ImmutableValueSet.builder().id(IdUtils.toString(valueSetState.getId())).entries(valueSetState.getEntries().stream().map(entry -> ImmutableValueSetEntry.builder().key(entry.getId()).value(entry.getLabel()).build()).toList()).build()));
            }
        });
        return valueSets;
    }

    @NonNull
    public List<Error> getErrors() {
        final ArrayList<Error> errors = new ArrayList<Error>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ErrorVisitor> visitErrorStates() {
                return Optional.of(errorState -> {
                    if (errorState.isActive()) {
                        errors.add(ImmutableError.builder().code(errorState.getCode()).id(IdUtils.toString(errorState.getItemId())).description(errorState.getLabel()).build());
                    }
                });
            }
        });
        return errors;
    }

    @NonNull
    public List<ActionItem> getItems() {
        final ArrayList<ActionItem> formItems = new ArrayList<ActionItem>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> formItems.add(DialobQuestionnaireSession.this.toActionItemFunction.apply(itemState)));
            }
        });
        return formItems;
    }

    public Optional<ActionItem> getItemById(@NonNull String itemId) {
        return this.dialobSession.getItemState(IdUtils.toId(itemId)).map(this.toActionItemFunction);
    }

    @NonNull
    public List<ActionItem> getVisibleItems() {
        final ArrayList<ActionItem> formItems = new ArrayList<ActionItem>();
        final Predicate<SessionObject> isVisiblePredicate = this.getIsVisiblePredicate();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (isVisiblePredicate.test(itemState)) {
                        formItems.add(DialobQuestionnaireSession.this.toActionItemFunction.apply(itemState));
                    }
                });
            }
        });
        return formItems;
    }

    @NonNull
    public Set<String> getActiveItems() {
        final HashSet<String> activeSet = new HashSet<String>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (itemState.isActive()) {
                        activeSet.add(IdUtils.toString(itemState.getId()));
                    }
                });
            }
        });
        return activeSet;
    }

    @NonNull
    public List<Answer> getAnswers() {
        final ArrayList<Answer> answers = new ArrayList<Answer>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (itemState.isActive() && Utils.isQuestionType(itemState)) {
                        ImmutableAnswer.Builder answerBuilder = ImmutableAnswer.builder().id(IdUtils.toString(itemState.getId())).value(itemState.getAnswer());
                        ItemId itemId = itemState.getPrototypeId();
                        if (itemId == null) {
                            itemId = itemState.getId();
                        }
                        DialobQuestionnaireSession.this.dialobProgram.getItem(itemId).ifPresent(item -> {
                            ValueType valueType = item.getValueType();
                            if (valueType != null) {
                                answerBuilder.type(valueType.getName());
                            }
                        });
                        answers.add(answerBuilder.build());
                    }
                });
            }
        });
        return answers;
    }

    @NonNull
    public List<VariableValue> getVariableValues() {
        final ArrayList<VariableValue> answers = new ArrayList<VariableValue>();
        this.dialobSession.accept(new DialobSessionVisitor(){

            @Override
            public Optional<DialobSessionVisitor.ItemVisitor> visitItemStates() {
                return Optional.of(itemState -> {
                    if (Utils.isProgramVariable(itemState.getType())) {
                        Object value = ConversionUtil.toJSON((Object)itemState.getValue());
                        answers.add(ImmutableVariableValue.builder().id(IdUtils.toString(itemState.getId())).value((Object)(value == null ? null : value.toString())).build());
                    }
                });
            }
        });
        return answers;
    }

    public void buildFullForm(@NonNull QuestionnaireSession.UpdatesCallback updatesCallback) {
        updatesCallback.removeAll();
        this.getLocale().ifPresent(arg_0 -> ((QuestionnaireSession.UpdatesCallback)updatesCallback).locale(arg_0));
        this.getVisibleItems().forEach(arg_0 -> ((QuestionnaireSession.UpdatesCallback)updatesCallback).questionAdded(arg_0));
        this.getValueSets().forEach(arg_0 -> ((QuestionnaireSession.UpdatesCallback)updatesCallback).valueSetAdded(arg_0));
        this.getErrors().forEach(arg_0 -> ((QuestionnaireSession.UpdatesCallback)updatesCallback).errorAdded(arg_0));
        if (this.dialobSession.isCompleted()) {
            updatesCallback.completed();
        }
    }

    public Optional<String> getSessionId() {
        return Optional.ofNullable(this.dialobSession.getId());
    }

    public String getTenantId() {
        return this.dialobSession.getTenantId();
    }

    protected void initialize() {
        this.getSessionId().ifPresent(arg_0 -> ((QuestionnaireEventPublisher)this.eventPublisher).created(arg_0));
    }

    public boolean activate() {
        if (!this.state.compareAndSet(State.PASSIVE, State.ACTIVATING) && !this.state.compareAndSet(State.NEW, State.ACTIVATING)) {
            return false;
        }
        ArrayList<Action> restoreActions = new ArrayList<Action>();
        if (this.metadata.getStatus() == Questionnaire.Metadata.Status.COMPLETED) {
            restoreActions.add(ActionsFactory.complete((String)this.dialobSession.getId()));
        }
        this.dispatchActions(restoreActions);
        this.state.set(State.ACTIVE);
        this.getSessionId().ifPresent(arg_0 -> ((QuestionnaireEventPublisher)this.eventPublisher).opened(arg_0));
        return true;
    }

    @NonNull
    static String[] convertRows(List<String> rows) {
        Pattern pattern = Pattern.compile("^([^\\[]+)\\[(\\d+)]$");
        return (String[])rows.stream().map(pattern::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1) + "." + matcher.group(2)).toArray(String[]::new);
    }

    public boolean passivate() {
        if (!this.state.compareAndSet(State.ACTIVE, State.PASSIVATING)) {
            return false;
        }
        return this.state.compareAndSet(State.PASSIVATING, State.PASSIVE);
    }

    public boolean isActive() {
        return this.state.get() == State.ACTIVE;
    }

    public boolean isCompleted() {
        return this.getStatus() == Questionnaire.Metadata.Status.COMPLETED;
    }

    public boolean usesLastestFormRevision() {
        return true;
    }

    @NonNull
    public String getFormId() {
        return this.dialobProgram.getProgram().getId();
    }

    public Optional<Locale> getLocale() {
        String language = this.dialobSession.getLanguage();
        if (StringUtils.isNotBlank((CharSequence)language)) {
            return Optional.of(Locale.of(language));
        }
        return Optional.empty();
    }

    public QuestionnaireSession.QuestionClientVisibility getQuestionClientVisibility() {
        return this.questionClientVisibility;
    }

    public void close() {
    }

    Predicate<SessionObject> getIsVisiblePredicate() {
        return switch (this.questionClientVisibility) {
            case QuestionnaireSession.QuestionClientVisibility.ALL -> itemState -> itemState != null && itemState.isDisplayItem();
            case QuestionnaireSession.QuestionClientVisibility.SHOW_DISABLED -> itemState -> itemState != null && itemState.isDisplayItem() && itemState.isActive();
            default -> itemState -> itemState != null && itemState.isDisplayItem() && itemState.isActive() && !itemState.isDisabled();
        };
    }

    Predicate<SessionObject> getIsActivePredicate() {
        return switch (this.questionClientVisibility) {
            case QuestionnaireSession.QuestionClientVisibility.ALL -> itemState -> itemState != null && itemState.isDisplayItem();
            case QuestionnaireSession.QuestionClientVisibility.SHOW_DISABLED -> itemState -> itemState != null && itemState.isActive();
            default -> itemState -> itemState != null && itemState.isDisplayItem() && itemState.isActive() && !itemState.isDisabled();
        };
    }

    private void publishQuestionnaireActions(String nextRevision, List<Action> actionQueue) {
        if (!actionQueue.isEmpty() && this.eventPublisher != null) {
            ImmutableActions.Builder builder = ImmutableActions.builder().rev(nextRevision);
            actionQueue.stream().map(action -> ImmutableAction.builder().from(action).serverEvent(Boolean.valueOf(true)).build()).forEach(arg_0 -> ((ImmutableActions.Builder)builder).addActions(arg_0));
            this.getSessionId().ifPresent(sessionId -> this.eventPublisher.actions(sessionId, (Actions)builder.build()));
        }
    }

    @NonNull
    public Questionnaire.Metadata.Status getStatus() {
        return this.dialobSession.isCompleted() ? Questionnaire.Metadata.Status.COMPLETED : Questionnaire.Metadata.Status.OPEN;
    }

    @NonNull
    public DialobProgram getDialobProgram() {
        return this.dialobProgram;
    }

    @NonNull
    public DialobSession getDialobSession() {
        return this.dialobSession;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialobQuestionnaireSession)) {
            return false;
        }
        DialobQuestionnaireSession other = (DialobQuestionnaireSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rev = this.getRev();
        String other$rev = other.getRev();
        if (this$rev == null ? other$rev != null : !this$rev.equals(other$rev)) {
            return false;
        }
        DialobSession this$dialobSession = this.getDialobSession();
        DialobSession other$dialobSession = other.getDialobSession();
        if (this$dialobSession == null ? other$dialobSession != null : !((Object)this$dialobSession).equals(other$dialobSession)) {
            return false;
        }
        DialobProgram this$dialobProgram = this.getDialobProgram();
        DialobProgram other$dialobProgram = other.getDialobProgram();
        if (this$dialobProgram == null ? other$dialobProgram != null : !((Object)this$dialobProgram).equals(other$dialobProgram)) {
            return false;
        }
        QuestionnaireSession.QuestionClientVisibility this$questionClientVisibility = this.getQuestionClientVisibility();
        QuestionnaireSession.QuestionClientVisibility other$questionClientVisibility = other.getQuestionClientVisibility();
        if (this$questionClientVisibility == null ? other$questionClientVisibility != null : !this$questionClientVisibility.equals(other$questionClientVisibility)) {
            return false;
        }
        Questionnaire.Metadata this$metadata = this.metadata;
        Questionnaire.Metadata other$metadata = other.metadata;
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DialobQuestionnaireSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rev = this.getRev();
        result = result * 59 + ($rev == null ? 43 : $rev.hashCode());
        DialobSession $dialobSession = this.getDialobSession();
        result = result * 59 + ($dialobSession == null ? 43 : ((Object)$dialobSession).hashCode());
        DialobProgram $dialobProgram = this.getDialobProgram();
        result = result * 59 + ($dialobProgram == null ? 43 : ((Object)$dialobProgram).hashCode());
        QuestionnaireSession.QuestionClientVisibility $questionClientVisibility = this.getQuestionClientVisibility();
        result = result * 59 + ($questionClientVisibility == null ? 43 : $questionClientVisibility.hashCode());
        Questionnaire.Metadata $metadata = this.metadata;
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DialobQuestionnaireSession(rev=" + this.getRev() + ", dialobSession=" + String.valueOf(this.getDialobSession()) + ", dialobProgram=" + String.valueOf(this.getDialobProgram()) + ", questionClientVisibility=" + String.valueOf(this.getQuestionClientVisibility()) + ", state=" + String.valueOf(this.state) + ", metadata=" + String.valueOf(this.metadata) + ", eventPublisher=" + String.valueOf(this.eventPublisher) + ", sessionContextFactory=" + String.valueOf(this.sessionContextFactory) + ", asyncFunctionInvoker=" + String.valueOf(this.asyncFunctionInvoker) + ", toActionItemFunction=" + String.valueOf(this.toActionItemFunction) + ")";
    }

    public static enum State {
        NEW(false),
        ACTIVATING(true),
        ACTIVE(true),
        PASSIVATING(false),
        PASSIVE(false);

        final boolean updatable;

        private State(boolean updatable) {
            this.updatable = updatable;
        }
    }

    public static class Builder {
        private QuestionnaireEventPublisher eventPublisher;
        private DialobSessionEvalContextFactory sessionContextFactory;
        private AsyncFunctionInvoker asyncFunctionInvoker;
        private String rev;
        private DialobSession dialobSession;
        private DialobProgram dialobProgram;
        private State state = State.NEW;
        private QuestionnaireSession.QuestionClientVisibility questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.ONLY_ENABLED;
        private Questionnaire.Metadata metadata;

        public Builder readFrom(@NonNull CodedInputStream input) throws IOException {
            this.rev = Utils.readNullableString(input);
            this.questionClientVisibility = QuestionnaireSession.QuestionClientVisibility.values()[input.readInt32()];
            this.state = State.values()[input.readInt32()];
            ImmutableQuestionnaireMetadata.Builder metadataBuilder = ImmutableQuestionnaireMetadata.builder().status(Questionnaire.Metadata.Status.valueOf((String)input.readString())).formId(input.readString()).formRev(Utils.readNullableString(input)).language(Utils.readNullableString(input)).label(Utils.readNullableString(input)).created(Utils.readNullableDate(input)).lastAnswer(Utils.readNullableDate(input)).creator(Utils.readNullableString(input)).owner(Utils.readNullableString(input)).tenantId(Utils.readNullableString(input)).submitUrl(Utils.readNullableString(input));
            int additionalPropertiesCount = input.readInt32();
            for (int i = 0; i < additionalPropertiesCount; ++i) {
                String key = input.readString();
                Object value = Utils.readObjectValue(input);
                metadataBuilder.putAdditionalProperties(key, value);
            }
            this.metadata = metadataBuilder.build();
            this.dialobSession = DialobSession.readFrom(input);
            return this;
        }

        public Builder eventPublisher(QuestionnaireEventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
            return this;
        }

        public Builder sessionContextFactory(DialobSessionEvalContextFactory sessionContextFactory) {
            this.sessionContextFactory = sessionContextFactory;
            return this;
        }

        public Builder asyncFunctionInvoker(AsyncFunctionInvoker asyncFunctionInvoker) {
            this.asyncFunctionInvoker = asyncFunctionInvoker;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Builder dialobSession(DialobSession dialobSession) {
            this.dialobSession = dialobSession;
            return this;
        }

        public Builder dialobProgram(DialobProgram dialobProgram) {
            this.dialobProgram = dialobProgram;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder questionClientVisibility(@NonNull QuestionnaireSession.QuestionClientVisibility questionClientVisibility) {
            this.questionClientVisibility = questionClientVisibility;
            return this;
        }

        public Builder metadata(Questionnaire.Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public DialobQuestionnaireSession build() {
            return new DialobQuestionnaireSession(Objects.requireNonNull(this.eventPublisher, "eventPublisher is null"), Objects.requireNonNull(this.sessionContextFactory, "sessionContextFactory is null"), Objects.requireNonNull(this.asyncFunctionInvoker, "asyncFunctionInvoker is null"), this.dialobSession, this.dialobProgram, this.rev, this.metadata, this.state, this.questionClientVisibility);
        }

        @Generated
        public Questionnaire.Metadata getMetadata() {
            return this.metadata;
        }
    }
}

