/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemRef;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ItemRef", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableItemRef
implements ItemRef {
    @Nullable
    private final ItemId parent;
    private final String id;

    private ImmutableItemRef(String id, Optional<? extends ItemId> parent) {
        this.id = Objects.requireNonNull(id, "id");
        this.parent = parent.orElse(null);
    }

    private ImmutableItemRef(ImmutableItemRef original, @Nullable ItemId parent, String id) {
        this.parent = parent;
        this.id = id;
    }

    @Override
    public Optional<ItemId> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public final ImmutableItemRef withParent(ItemId value) {
        ItemId newValue = Objects.requireNonNull(value, "parent");
        if (this.parent == newValue) {
            return this;
        }
        return new ImmutableItemRef(this, newValue, this.id);
    }

    @Override
    public final ImmutableItemRef withParent(Optional<? extends ItemId> optional) {
        ItemId value = optional.orElse(null);
        if (this.parent == value) {
            return this;
        }
        return new ImmutableItemRef(this, value, this.id);
    }

    public final ImmutableItemRef withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableItemRef(this, this.parent, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItemRef && this.equalsByValue((ImmutableItemRef)another);
    }

    private boolean equalsByValue(ImmutableItemRef another) {
        return Objects.equals(this.parent, another.parent) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ItemRef").omitNullValues().add("parent", (Object)this.parent).add("id", (Object)this.id).toString();
    }

    public static ImmutableItemRef of(String id, Optional<? extends ItemId> parent) {
        return new ImmutableItemRef(id, parent);
    }

    public static ImmutableItemRef copyOf(ItemRef instance) {
        if (instance instanceof ImmutableItemRef) {
            return (ImmutableItemRef)instance;
        }
        return ImmutableItemRef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ItemRef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private ItemId parent;
        @Nullable
        private String id;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ItemRef instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ItemId instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<ItemId> parentOptional;
            ItemId instance;
            long bits = 0L;
            if (object instanceof ItemRef) {
                instance = (ItemRef)object;
                if ((bits & 1L) == 0L) {
                    parentOptional = instance.getParent();
                    if (parentOptional.isPresent()) {
                        this.parent(parentOptional);
                    }
                    bits |= 1L;
                }
                this.id(instance.getId());
            }
            if (object instanceof ItemId) {
                instance = (ItemId)object;
                if ((bits & 1L) == 0L) {
                    parentOptional = instance.getParent();
                    if (parentOptional.isPresent()) {
                        this.parent(parentOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder parent(ItemId parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent(Optional<? extends ItemId> parent) {
            this.parent = parent.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableItemRef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableItemRef(null, this.parent, this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ItemRef, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

