/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import io.dialob.session.engine.session.command.Triggers;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.command.event.ImmutableItemAddedEvent;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemStates;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface RowItemsAddedEventsProvider
extends Triggers.EventsProvider<ItemStates> {
    @Value.Parameter
    public ItemId getRowProtoTypeId();

    @Override
    default public Stream<Event> createEvents(ItemStates originalState, ItemStates updatedState) {
        if (originalState == null && updatedState == null) {
            return Stream.of(ImmutableItemAddedEvent.of(this.getRowProtoTypeId(), this.getRowProtoTypeId()));
        }
        if (updatedState == null) {
            return Stream.empty();
        }
        Set<ItemId> newItems = updatedState.getItemStates().keySet();
        if (originalState != null) {
            newItems = new HashSet<ItemId>(newItems);
            newItems.removeAll(originalState.getItemStates().keySet());
        }
        return newItems.stream().map(itemId -> ImmutableItemAddedEvent.of(itemId, this.getRowProtoTypeId()));
    }
}

