/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.event.TargetEvent;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TargetEvent", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableTargetEvent
implements TargetEvent {
    private final ItemId targetId;

    private ImmutableTargetEvent(ItemId targetId) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
    }

    private ImmutableTargetEvent(ImmutableTargetEvent original, ItemId targetId) {
        this.targetId = targetId;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    public final ImmutableTargetEvent withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableTargetEvent(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTargetEvent && this.equalsByValue((ImmutableTargetEvent)another);
    }

    private boolean equalsByValue(ImmutableTargetEvent another) {
        return this.targetId.equals(another.targetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.targetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TargetEvent").omitNullValues().add("targetId", (Object)this.targetId).toString();
    }

    public static ImmutableTargetEvent of(ItemId targetId) {
        return new ImmutableTargetEvent(targetId);
    }

    public static ImmutableTargetEvent copyOf(TargetEvent instance) {
        if (instance instanceof ImmutableTargetEvent) {
            return (ImmutableTargetEvent)instance;
        }
        return ImmutableTargetEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TargetEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private ItemId targetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TargetEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.targetId(instance.getTargetId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTargetEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTargetEvent(null, this.targetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            return "Cannot build TargetEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

