/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.event.AttributeEvent;
import io.dialob.session.engine.session.command.event.GroupEvent;
import io.dialob.session.engine.session.command.event.RowGroupItemsInitEvent;
import io.dialob.session.engine.session.command.event.TargetEvent;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RowGroupItemsInitEvent", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRowGroupItemsInitEvent
implements RowGroupItemsInitEvent {
    private final TargetEvent target;
    private final ItemId groupId;
    private final ItemId prototypeId;

    private ImmutableRowGroupItemsInitEvent(ItemId groupId, ItemId prototypeId, TargetEvent target) {
        this.groupId = Objects.requireNonNull(groupId, "groupId");
        this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        this.target = Objects.requireNonNull(target, "target");
    }

    private ImmutableRowGroupItemsInitEvent(ImmutableRowGroupItemsInitEvent original, TargetEvent target, ItemId groupId, ItemId prototypeId) {
        this.target = target;
        this.groupId = groupId;
        this.prototypeId = prototypeId;
    }

    @Override
    public TargetEvent getTarget() {
        return this.target;
    }

    @Override
    public ItemId getGroupId() {
        return this.groupId;
    }

    @Override
    public ItemId getPrototypeId() {
        return this.prototypeId;
    }

    public final ImmutableRowGroupItemsInitEvent withTarget(TargetEvent value) {
        if (this.target == value) {
            return this;
        }
        TargetEvent newValue = Objects.requireNonNull(value, "target");
        return new ImmutableRowGroupItemsInitEvent(this, newValue, this.groupId, this.prototypeId);
    }

    public final ImmutableRowGroupItemsInitEvent withGroupId(ItemId value) {
        if (this.groupId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "groupId");
        return new ImmutableRowGroupItemsInitEvent(this, this.target, newValue, this.prototypeId);
    }

    public final ImmutableRowGroupItemsInitEvent withPrototypeId(ItemId value) {
        if (this.prototypeId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "prototypeId");
        return new ImmutableRowGroupItemsInitEvent(this, this.target, this.groupId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRowGroupItemsInitEvent && this.equalsByValue((ImmutableRowGroupItemsInitEvent)another);
    }

    private boolean equalsByValue(ImmutableRowGroupItemsInitEvent another) {
        return this.target.equals(another.target) && this.groupId.equals(another.groupId) && this.prototypeId.equals(another.prototypeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.target.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.prototypeId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RowGroupItemsInitEvent").omitNullValues().add("target", (Object)this.target).add("groupId", (Object)this.groupId).add("prototypeId", (Object)this.prototypeId).toString();
    }

    public static ImmutableRowGroupItemsInitEvent of(ItemId groupId, ItemId prototypeId, TargetEvent target) {
        return new ImmutableRowGroupItemsInitEvent(groupId, prototypeId, target);
    }

    public static ImmutableRowGroupItemsInitEvent copyOf(RowGroupItemsInitEvent instance) {
        if (instance instanceof ImmutableRowGroupItemsInitEvent) {
            return (ImmutableRowGroupItemsInitEvent)instance;
        }
        return ImmutableRowGroupItemsInitEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RowGroupItemsInitEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET = 1L;
        private static final long INIT_BIT_GROUP_ID = 2L;
        private static final long INIT_BIT_PROTOTYPE_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private TargetEvent target;
        @Nullable
        private ItemId groupId;
        @Nullable
        private ItemId prototypeId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GroupEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AttributeEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RowGroupItemsInitEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            AttributeEvent instance;
            long bits = 0L;
            if (object instanceof GroupEvent) {
                instance = (GroupEvent)object;
                if ((bits & 1L) == 0L) {
                    this.target(instance.getTarget());
                    bits |= 1L;
                }
            }
            if (object instanceof AttributeEvent) {
                instance = (AttributeEvent)object;
                if ((bits & 1L) == 0L) {
                    this.target(instance.getTarget());
                    bits |= 1L;
                }
            }
            if (object instanceof RowGroupItemsInitEvent) {
                instance = (RowGroupItemsInitEvent)object;
                this.groupId(instance.getGroupId());
                this.prototypeId(instance.getPrototypeId());
                if ((bits & 1L) == 0L) {
                    this.target(instance.getTarget());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder target(TargetEvent target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groupId(ItemId groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prototypeId(ItemId prototypeId) {
            this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRowGroupItemsInitEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRowGroupItemsInitEvent(null, this.target, this.groupId, this.prototypeId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("target");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("prototypeId");
            }
            return "Cannot build RowGroupItemsInitEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

