/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.event.AttributeEvent;
import io.dialob.session.engine.session.command.event.GroupEvent;
import io.dialob.session.engine.session.command.event.ItemsChangedEvent;
import io.dialob.session.engine.session.command.event.TargetEvent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ItemsChangedEvent", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableItemsChangedEvent
implements ItemsChangedEvent {
    private final TargetEvent target;

    private ImmutableItemsChangedEvent(TargetEvent target) {
        this.target = Objects.requireNonNull(target, "target");
    }

    private ImmutableItemsChangedEvent(ImmutableItemsChangedEvent original, TargetEvent target) {
        this.target = target;
    }

    @Override
    public TargetEvent getTarget() {
        return this.target;
    }

    public final ImmutableItemsChangedEvent withTarget(TargetEvent value) {
        if (this.target == value) {
            return this;
        }
        TargetEvent newValue = Objects.requireNonNull(value, "target");
        return new ImmutableItemsChangedEvent(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItemsChangedEvent && this.equalsByValue((ImmutableItemsChangedEvent)another);
    }

    private boolean equalsByValue(ImmutableItemsChangedEvent another) {
        return this.target.equals(another.target);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.target.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ItemsChangedEvent").omitNullValues().add("target", (Object)this.target).toString();
    }

    public static ImmutableItemsChangedEvent of(TargetEvent target) {
        return new ImmutableItemsChangedEvent(target);
    }

    public static ImmutableItemsChangedEvent copyOf(ItemsChangedEvent instance) {
        if (instance instanceof ImmutableItemsChangedEvent) {
            return (ImmutableItemsChangedEvent)instance;
        }
        return ImmutableItemsChangedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ItemsChangedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET = 1L;
        private long initBits = 1L;
        @Nullable
        private TargetEvent target;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ItemsChangedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GroupEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AttributeEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            AttributeEvent instance;
            long bits = 0L;
            if (object instanceof ItemsChangedEvent) {
                instance = (ItemsChangedEvent)object;
                if ((bits & 1L) == 0L) {
                    this.target(instance.getTarget());
                    bits |= 1L;
                }
            }
            if (object instanceof GroupEvent) {
                instance = (GroupEvent)object;
                if ((bits & 1L) == 0L) {
                    this.target(instance.getTarget());
                    bits |= 1L;
                }
            }
            if (object instanceof AttributeEvent) {
                instance = (AttributeEvent)object;
                if ((bits & 1L) == 0L) {
                    this.target(instance.getTarget());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder target(TargetEvent target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableItemsChangedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableItemsChangedEvent(null, this.target);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("target");
            }
            return "Cannot build ItemsChangedEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

