/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.AsyncFunctionCall;
import io.dialob.session.engine.session.ImmutableAsyncFunctionCall;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface VariableUpdateCommand
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Value.Parameter(order=1)
    public Expression getExpression();

    @Override
    @NonNull
    default public Set<EventMatcher> getEventMatchers() {
        return this.getExpression().getEvalRequiredConditions();
    }

    @Override
    @NonNull
    default public ItemState update(@NonNull EvalContext context, @NonNull ItemState itemState) {
        Object eval = this.getExpression().eval(context);
        if (this.isPending(eval)) {
            context.queueAsyncFunctionCall(((ImmutableAsyncFunctionCall)eval).withTargetId((ItemId)this.getTargetId()));
            return itemState.update().setStatus(ItemState.Status.PENDING).get();
        }
        return itemState.update().setValue(eval).get();
    }

    default public boolean isPending(Object eval) {
        return eval instanceof AsyncFunctionCall;
    }
}

