/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.session.command.ImmutableDynamicTrigger;
import io.dialob.session.engine.session.command.ImmutableStaticTrigger;
import io.dialob.session.engine.session.command.ImmutableTriggers;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.event.ActivePageUpdatedEvent;
import io.dialob.session.engine.session.command.event.AnyInvalidAnswersUpdatedEvent;
import io.dialob.session.engine.session.command.event.AvailableItemsUpdatedEvent;
import io.dialob.session.engine.session.command.event.Event;
import io.dialob.session.engine.session.command.event.ImmutableActivePageUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableActiveUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableAnsweredUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableAnyInvalidAnswersUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableAvailableItemsUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableDescriptionUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableDisabledUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableErrorActiveUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableItemsChangedEvent;
import io.dialob.session.engine.session.command.event.ImmutableLabelUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableRequiredUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableRowCanBeRemovedUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableRowGroupItemsInitEvent;
import io.dialob.session.engine.session.command.event.ImmutableRowsCanBeAddedUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableStatusUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableTargetEvent;
import io.dialob.session.engine.session.command.event.ImmutableValidUpdatedEvent;
import io.dialob.session.engine.session.command.event.ImmutableValueSetUpdatedEvent;
import io.dialob.session.engine.session.command.event.SessionLocaleUpdatedEvent;
import io.dialob.session.engine.session.command.event.SessionUpdatedEvent;
import io.dialob.session.engine.session.command.event.TargetEvent;
import io.dialob.session.engine.session.command.event.ValueSetEvent;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ValueSetId;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Enclosing
public class Triggers {
    public static final ActivePageUpdatedEvent ACTIVE_PAGE_UPDATED_EVENT = ImmutableActivePageUpdatedEvent.builder().build();
    public static final AvailableItemsUpdatedEvent AVAILABLE_ITEMS_UPDATED_EVENT = ImmutableAvailableItemsUpdatedEvent.builder().build();
    public static final AnyInvalidAnswersUpdatedEvent ANY_INVALID_ANSWERS_UPDATED_EVENT = ImmutableAnyInvalidAnswersUpdatedEvent.builder().build();

    public static <T> TriggerBuilder<T> trigger(@NonNull EventsProvider<T> eventsProvider) {
        return new TriggerBuilder<T>(Objects.requireNonNull(eventsProvider));
    }

    public static <T> TriggerBuilder<T> trigger(@NonNull Event event) {
        return new TriggerBuilder(Objects.requireNonNull(event));
    }

    public static TargetEvent onTarget(@NonNull ItemId targetId) {
        return Triggers.stateChangedEvent(targetId);
    }

    public static ValueSetEvent valueSetUpdatedEvent(@NonNull ValueSetId valueSetId) {
        return ImmutableValueSetUpdatedEvent.of(valueSetId);
    }

    public static TargetEvent stateChangedEvent(@NonNull ItemId targetId) {
        return ImmutableTargetEvent.of(targetId);
    }

    public static SessionUpdatedEvent sessionLocaleUpdatedEvent() {
        return SessionLocaleUpdatedEvent.INSTANCE;
    }

    public static Event errorActivityUpdatedEvent(@NonNull ErrorId errorId) {
        return ImmutableErrorActiveUpdatedEvent.of(errorId);
    }

    public static Event activityUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableActiveUpdatedEvent.of(targetEvent);
    }

    public static Event rowsCanBeAddedUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableRowsCanBeAddedUpdatedEvent.of(targetEvent);
    }

    public static Event rowCanBeRemovedUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableRowCanBeRemovedUpdatedEvent.of(targetEvent);
    }

    public static Event labelUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableLabelUpdatedEvent.of(targetEvent);
    }

    public static Event descriptionUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableDescriptionUpdatedEvent.of(targetEvent);
    }

    public static Event requiredUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableRequiredUpdatedEvent.of(targetEvent);
    }

    public static Event answeredUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableAnsweredUpdatedEvent.of(targetEvent);
    }

    public static Event validityUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableValidUpdatedEvent.of(targetEvent);
    }

    public static Event itemsChangedEvent(TargetEvent targetEvent) {
        return ImmutableItemsChangedEvent.of(targetEvent);
    }

    public static EventsProvider<ItemState> rowGroupItemsInitEvent(ItemId prototypeId) {
        return ImmutableTriggers.RowGroupItemsInitEventsProvider.of(prototypeId);
    }

    public static Event disabledUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableDisabledUpdatedEvent.of(targetEvent);
    }

    public static Event statusUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableStatusUpdatedEvent.of(targetEvent);
    }

    public static EventsProvider<ItemState> groupItemsUpdatedEvent(TargetEvent targetEvent) {
        return ImmutableTriggers.GroupItemsUpdatedEventProvider.of(targetEvent);
    }

    public static EventsProvider<ItemState> groupItemsUpdatedEvent(ItemId prototypeId) {
        return ImmutableTriggers.GroupItemsUpdatedEventsProvider.of(prototypeId);
    }

    public static Event activePageUpdatedEvent() {
        return ACTIVE_PAGE_UPDATED_EVENT;
    }

    public static Event availableItemsUpdatedEvent() {
        return AVAILABLE_ITEMS_UPDATED_EVENT;
    }

    public static Event anyInvalidAnswersUpdatedEvent() {
        return ANY_INVALID_ANSWERS_UPDATED_EVENT;
    }

    static class TriggerBuilder<T> {
        private EventsProvider<T> eventsProvider;
        private Event event;

        public TriggerBuilder(@NonNull EventsProvider<T> eventsProvider) {
            this.eventsProvider = Objects.requireNonNull(eventsProvider);
        }

        public TriggerBuilder(Event event) {
            this.event = event;
        }

        public Trigger<T> when(@NonNull BiPredicate<T, T> predicate) {
            if (this.event != null) {
                return ImmutableStaticTrigger.builder().when(predicate).addAllEvents(this.event).build();
            }
            return ImmutableDynamicTrigger.builder().when(predicate).eventsProvider(this.eventsProvider).build();
        }
    }

    @FunctionalInterface
    public static interface EventsProvider<T>
    extends Serializable {
        public Stream<Event> createEvents(T var1, T var2);
    }

    @Value.Immutable
    static interface GroupItemsUpdatedEventsProvider
    extends EventsProvider<ItemState> {
        @Value.Parameter
        public ItemId getPrototypeId();

        @Override
        default public Stream<Event> createEvents(ItemState originalState, ItemState updatedState) {
            return originalState == null && updatedState == null ? Stream.of(Triggers.itemsChangedEvent(Triggers.onTarget(this.getPrototypeId()))) : Stream.of(Triggers.itemsChangedEvent(Triggers.onTarget(updatedState.getId())));
        }
    }

    @Value.Immutable
    static interface GroupItemsUpdatedEventProvider
    extends EventsProvider<ItemState> {
        @Value.Parameter
        public TargetEvent getTargetEvent();

        @Override
        default public Stream<Event> createEvents(ItemState originalState, ItemState updatedState) {
            return Stream.of(Triggers.itemsChangedEvent(this.getTargetEvent()));
        }
    }

    @Value.Immutable
    static interface RowGroupItemsInitEventsProvider
    extends EventsProvider<ItemState> {
        @Value.Parameter
        public ItemId getPrototypeId();

        @Override
        default public Stream<Event> createEvents(ItemState originalState, ItemState updatedState) {
            return originalState == null && updatedState == null ? Stream.of(ImmutableRowGroupItemsInitEvent.of(this.getPrototypeId(), this.getPrototypeId(), Triggers.onTarget(this.getPrototypeId()))) : Stream.of(ImmutableRowGroupItemsInitEvent.of(updatedState.getId(), this.getPrototypeId(), Triggers.onTarget(this.getPrototypeId())));
        }
    }
}

