/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.AbstractUpdateBooleanAttributeCommand;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.command.UpdateRowsCanBeAddedCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateRowsCanBeAddedCommand", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableUpdateRowsCanBeAddedCommand
implements UpdateRowsCanBeAddedCommand {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;
    private final Expression expression;

    private ImmutableUpdateRowsCanBeAddedCommand(ItemId targetId, Expression expression, Iterable<? extends Trigger<ItemState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.expression = Objects.requireNonNull(expression, "expression");
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableUpdateRowsCanBeAddedCommand(ImmutableUpdateRowsCanBeAddedCommand original, ImmutableList<Trigger<ItemState>> triggers, ItemId targetId, Expression expression) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.expression = expression;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @SafeVarargs
    public final ImmutableUpdateRowsCanBeAddedCommand withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUpdateRowsCanBeAddedCommand(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.expression);
    }

    public final ImmutableUpdateRowsCanBeAddedCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUpdateRowsCanBeAddedCommand(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.expression);
    }

    public final ImmutableUpdateRowsCanBeAddedCommand withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableUpdateRowsCanBeAddedCommand(this, this.triggers, newValue, this.expression);
    }

    public final ImmutableUpdateRowsCanBeAddedCommand withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableUpdateRowsCanBeAddedCommand(this, this.triggers, this.targetId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateRowsCanBeAddedCommand && this.equalsByValue((ImmutableUpdateRowsCanBeAddedCommand)another);
    }

    private boolean equalsByValue(ImmutableUpdateRowsCanBeAddedCommand another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && this.expression.equals(another.expression);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + this.expression.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UpdateRowsCanBeAddedCommand").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("expression", (Object)this.expression).toString();
    }

    public static ImmutableUpdateRowsCanBeAddedCommand of(ItemId targetId, Expression expression, List<Trigger<ItemState>> triggers) {
        return ImmutableUpdateRowsCanBeAddedCommand.of(targetId, expression, triggers);
    }

    public static ImmutableUpdateRowsCanBeAddedCommand of(ItemId targetId, Expression expression, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableUpdateRowsCanBeAddedCommand(targetId, expression, triggers);
    }

    public static ImmutableUpdateRowsCanBeAddedCommand copyOf(UpdateRowsCanBeAddedCommand instance) {
        if (instance instanceof ImmutableUpdateRowsCanBeAddedCommand) {
            return (ImmutableUpdateRowsCanBeAddedCommand)instance;
        }
        return ImmutableUpdateRowsCanBeAddedCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateRowsCanBeAddedCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private static final long INIT_BIT_EXPRESSION = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;
        @Nullable
        private Expression expression;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractUpdateBooleanAttributeCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateRowsCanBeAddedCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            AbstractUpdateBooleanAttributeCommand instance;
            long bits = 0L;
            if (object instanceof AbstractUpdateBooleanAttributeCommand) {
                instance = (AbstractUpdateBooleanAttributeCommand)object;
                if ((bits & 1L) == 0L) {
                    this.expression(instance.getExpression());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateRowsCanBeAddedCommand) {
                instance = (UpdateRowsCanBeAddedCommand)object;
                this.targetId((ItemId)instance.getTargetId());
                this.addAllTriggers(instance.getTriggers());
                if ((bits & 1L) == 0L) {
                    this.expression(instance.getExpression());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateRowsCanBeAddedCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateRowsCanBeAddedCommand(null, (ImmutableList<Trigger<ItemState>>)this.triggers.build(), this.targetId, this.expression);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expression");
            }
            return "Cannot build UpdateRowsCanBeAddedCommand, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

