/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.SetAnswer;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SetAnswer", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSetAnswer
implements SetAnswer {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;
    @Nullable
    private final Object answer;

    private ImmutableSetAnswer(ItemId targetId, @Nullable Object answer, Iterable<? extends Trigger<ItemState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.answer = answer;
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableSetAnswer(ImmutableSetAnswer original, ImmutableList<Trigger<ItemState>> triggers, ItemId targetId, @Nullable Object answer) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.answer = answer;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @Override
    @Nullable
    public Object getAnswer() {
        return this.answer;
    }

    @SafeVarargs
    public final ImmutableSetAnswer withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSetAnswer(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.answer);
    }

    public final ImmutableSetAnswer withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSetAnswer(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.answer);
    }

    public final ImmutableSetAnswer withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableSetAnswer(this, this.triggers, newValue, this.answer);
    }

    public final ImmutableSetAnswer withAnswer(@Nullable Object value) {
        if (this.answer == value) {
            return this;
        }
        return new ImmutableSetAnswer(this, this.triggers, this.targetId, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetAnswer && this.equalsByValue((ImmutableSetAnswer)another);
    }

    private boolean equalsByValue(ImmutableSetAnswer another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && Objects.equals(this.answer, another.answer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + Objects.hashCode(this.answer);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SetAnswer").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("answer", this.answer).toString();
    }

    public static ImmutableSetAnswer of(ItemId targetId, @Nullable Object answer, List<Trigger<ItemState>> triggers) {
        return ImmutableSetAnswer.of(targetId, answer, triggers);
    }

    public static ImmutableSetAnswer of(ItemId targetId, @Nullable Object answer, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableSetAnswer(targetId, answer, triggers);
    }

    public static ImmutableSetAnswer copyOf(SetAnswer instance) {
        if (instance instanceof ImmutableSetAnswer) {
            return (ImmutableSetAnswer)instance;
        }
        return ImmutableSetAnswer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetAnswer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @javax.annotation.Nullable
        private ItemId targetId;
        @javax.annotation.Nullable
        private Object answer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SetAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ItemId)instance.getTargetId());
            Object answerValue = instance.getAnswer();
            if (answerValue != null) {
                this.answer(answerValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder answer(@Nullable Object answer) {
            this.answer = answer;
            return this;
        }

        public ImmutableSetAnswer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetAnswer(null, (ImmutableList<Trigger<ItemState>>)this.triggers.build(), this.targetId, this.answer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            return "Cannot build SetAnswer, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

