/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.InitRowGroupItemsCommand;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InitRowGroupItemsCommand", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableInitRowGroupItemsCommand
implements InitRowGroupItemsCommand {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;

    private ImmutableInitRowGroupItemsCommand(ItemId targetId, Iterable<? extends Trigger<ItemState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableInitRowGroupItemsCommand(ImmutableInitRowGroupItemsCommand original, ImmutableList<Trigger<ItemState>> triggers, ItemId targetId) {
        this.triggers = triggers;
        this.targetId = targetId;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @SafeVarargs
    public final ImmutableInitRowGroupItemsCommand withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableInitRowGroupItemsCommand(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableInitRowGroupItemsCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableInitRowGroupItemsCommand(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId);
    }

    public final ImmutableInitRowGroupItemsCommand withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableInitRowGroupItemsCommand(this, this.triggers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInitRowGroupItemsCommand && this.equalsByValue((ImmutableInitRowGroupItemsCommand)another);
    }

    private boolean equalsByValue(ImmutableInitRowGroupItemsCommand another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InitRowGroupItemsCommand").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).toString();
    }

    public static ImmutableInitRowGroupItemsCommand of(ItemId targetId, List<Trigger<ItemState>> triggers) {
        return ImmutableInitRowGroupItemsCommand.of(targetId, triggers);
    }

    public static ImmutableInitRowGroupItemsCommand of(ItemId targetId, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableInitRowGroupItemsCommand(targetId, triggers);
    }

    public static ImmutableInitRowGroupItemsCommand copyOf(InitRowGroupItemsCommand instance) {
        if (instance instanceof ImmutableInitRowGroupItemsCommand) {
            return (ImmutableInitRowGroupItemsCommand)instance;
        }
        return ImmutableInitRowGroupItemsCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InitRowGroupItemsCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @Nullable
        private ItemId targetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InitRowGroupItemsCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ItemId)instance.getTargetId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInitRowGroupItemsCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInitRowGroupItemsCommand(null, (ImmutableList<Trigger<ItemState>>)this.triggers.build(), this.targetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            return "Cannot build InitRowGroupItemsCommand, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

