/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;

public interface ErrorUpdateCommand
extends UpdateCommand<ErrorId, ErrorState> {
    @Value.Parameter(order=1)
    public Expression getExpression();

    @Override
    @NonNull
    default public Set<EventMatcher> getEventMatchers() {
        Set<EventMatcher> eventMatchers = this.getExpression().getEvalRequiredConditions();
        if (((ErrorId)this.getTargetId()).isPartial()) {
            HashSet<EventMatcher> builder = new HashSet<EventMatcher>(eventMatchers);
            builder.add(EventMatchers.whenItemAdded(((ErrorId)this.getTargetId()).getItemId()));
            ErrorUpdateCommand.findConcreteItem(this.getTargetId()).map(EventMatchers::whenItemsChanged).ifPresent(builder::add);
            return Set.copyOf(builder);
        }
        return eventMatchers;
    }

    public static Optional<ItemId> findConcreteItem(ItemId id) {
        if (id.isPartial()) {
            return id.getParent().flatMap(ErrorUpdateCommand::findConcreteItem);
        }
        return Optional.of(id);
    }
}

