/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemIndex;
import io.dialob.session.engine.session.model.ItemState;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface DeleteRow
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Value.Parameter(order=1)
    public ItemId getToBeRemoved();

    @Override
    @NonNull
    default public ItemState update(@NonNull EvalContext context, @NonNull ItemState itemState) {
        List rowNumbers = (List)itemState.getValue();
        if (rowNumbers == null) {
            rowNumbers = Collections.emptyList();
        }
        rowNumbers = new ArrayList(rowNumbers);
        ItemId toBeRemoved = this.getToBeRemoved();
        Optional<ItemState> rowToBeRemoved = context.getItemState(toBeRemoved);
        if (rowToBeRemoved.isPresent() && !rowToBeRemoved.get().isRowCanBeRemoved()) {
            return itemState;
        }
        BigInteger rowToRemove = null;
        if (toBeRemoved instanceof ItemIndex) {
            ItemIndex index = (ItemIndex)toBeRemoved;
            rowToRemove = BigInteger.valueOf(index.getIndex().intValue());
        }
        rowNumbers.remove(rowToRemove);
        return itemState.update().setAnswer(rowNumbers).setValue(rowNumbers).get();
    }
}

