/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public interface AddRow
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Override
    @NonNull
    default public ItemState update(@NonNull EvalContext context, @NonNull ItemState itemState) {
        if (itemState.isRowsCanBeAdded()) {
            List rowNumbers = (List)itemState.getValue();
            if (rowNumbers == null) {
                rowNumbers = Collections.emptyList();
            }
            rowNumbers = new ArrayList(rowNumbers);
            BigInteger newRowId = rowNumbers.stream().reduce(BigInteger::max).map(i -> i.add(BigInteger.ONE)).orElse(BigInteger.ZERO);
            rowNumbers.add(newRowId);
            return itemState.update().setAnswer(rowNumbers).setValue(rowNumbers).get();
        }
        return itemState;
    }
}

