/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.AsyncFunctionCall;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AsyncFunctionCall", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableAsyncFunctionCall
implements AsyncFunctionCall {
    @Nullable
    private final String id;
    @Nullable
    private final ItemId targetId;
    private final String functionName;
    private final Object[] args;

    private ImmutableAsyncFunctionCall(@Nullable String id, @Nullable ItemId targetId, String functionName, Object[] args) {
        this.id = id;
        this.targetId = targetId;
        this.functionName = functionName;
        this.args = args;
    }

    @Override
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    public Optional<ItemId> getTargetId() {
        return Optional.ofNullable(this.targetId);
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public Object[] getArgs() {
        return (Object[])this.args.clone();
    }

    public final ImmutableAsyncFunctionCall withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableAsyncFunctionCall(newValue, this.targetId, this.functionName, this.args);
    }

    public final ImmutableAsyncFunctionCall withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableAsyncFunctionCall(value, this.targetId, this.functionName, this.args);
    }

    public final ImmutableAsyncFunctionCall withTargetId(ItemId value) {
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        if (this.targetId == newValue) {
            return this;
        }
        return new ImmutableAsyncFunctionCall(this.id, newValue, this.functionName, this.args);
    }

    public final ImmutableAsyncFunctionCall withTargetId(Optional<? extends ItemId> optional) {
        ItemId value = optional.orElse(null);
        if (this.targetId == value) {
            return this;
        }
        return new ImmutableAsyncFunctionCall(this.id, value, this.functionName, this.args);
    }

    public final ImmutableAsyncFunctionCall withFunctionName(String value) {
        String newValue = Objects.requireNonNull(value, "functionName");
        if (this.functionName.equals(newValue)) {
            return this;
        }
        return new ImmutableAsyncFunctionCall(this.id, this.targetId, newValue, this.args);
    }

    public final ImmutableAsyncFunctionCall withArgs(Object ... elements) {
        Object[] newValue = (Object[])elements.clone();
        return new ImmutableAsyncFunctionCall(this.id, this.targetId, this.functionName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAsyncFunctionCall && this.equalsByValue((ImmutableAsyncFunctionCall)another);
    }

    private boolean equalsByValue(ImmutableAsyncFunctionCall another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.targetId, another.targetId) && this.functionName.equals(another.functionName) && Arrays.equals(this.args, another.args);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.targetId);
        h += (h << 5) + this.functionName.hashCode();
        h += (h << 5) + Arrays.hashCode(this.args);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AsyncFunctionCall").omitNullValues().add("id", (Object)this.id).add("targetId", (Object)this.targetId).add("functionName", (Object)this.functionName).add("args", (Object)Arrays.toString(this.args)).toString();
    }

    public static ImmutableAsyncFunctionCall copyOf(AsyncFunctionCall instance) {
        if (instance instanceof ImmutableAsyncFunctionCall) {
            return (ImmutableAsyncFunctionCall)instance;
        }
        return ImmutableAsyncFunctionCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AsyncFunctionCall", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FUNCTION_NAME = 1L;
        private static final long INIT_BIT_ARGS = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private ItemId targetId;
        @Nullable
        private String functionName;
        @Nullable
        private Object[] args;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AsyncFunctionCall instance) {
            Optional<ItemId> targetIdOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.getId();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((targetIdOptional = instance.getTargetId()).isPresent()) {
                this.targetId(targetIdOptional);
            }
            this.functionName(instance.getFunctionName());
            this.args(instance.getArgs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(Optional<? extends ItemId> targetId) {
            this.targetId = targetId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder functionName(String functionName) {
            this.functionName = Objects.requireNonNull(functionName, "functionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Object ... args) {
            this.args = (Object[])args.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAsyncFunctionCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAsyncFunctionCall(this.id, this.targetId, this.functionName, this.args);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("functionName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("args");
            }
            return "Cannot build AsyncFunctionCall, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

