/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.expr.arith.RowItemsExpression;
import io.dialob.session.engine.program.model.AbstractItemVisitor;
import io.dialob.session.engine.program.model.DisplayItem;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Group;
import io.dialob.session.engine.program.model.Item;
import io.dialob.session.engine.program.model.Program;
import io.dialob.session.engine.program.model.ProgramVisitor;
import io.dialob.session.engine.program.model.VariableItem;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.CommandFactory;
import io.dialob.session.engine.session.command.UpdateCommand;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ImmutableErrorId;
import io.dialob.session.engine.session.model.ImmutableItemIndex;
import io.dialob.session.engine.session.model.ImmutableItemRef;
import io.dialob.session.engine.session.model.ImmutableScope;
import io.dialob.session.engine.session.model.ImmutableValueSetId;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;

public class CreateDialobSessionProgramVisitor
implements ProgramVisitor {
    private final String tenantId;
    private final String sessionId;
    private final String language;
    private final Date completed;
    private final Date opened;
    private final Date lastAnswer;
    private DialobSession dialobSession;
    private Program program;
    private final List<ItemState> items = new ArrayList<ItemState>();
    private final List<ItemState> prototypeItems = new ArrayList<ItemState>();
    private final List<ValueSetState> valueSets = new ArrayList<ValueSetState>();
    private final List<ErrorState> errors = new ArrayList<ErrorState>();
    private final List<ErrorState> errorPrototypes = new ArrayList<ErrorState>();
    private final List<Command<?>> updates = new ArrayList();
    private final InitialValueResolver initialValueResolver;
    private final Map<ItemId, List<Command<?>>> itemCommands;
    private final List<ItemState> rowGroups = new ArrayList<ItemState>();
    private final ItemId activePage;
    private final ProvidedValueSetEntriesResolver findProvidedValueSetEntries;

    public CreateDialobSessionProgramVisitor(String tenantId, String sessionId, String language, String activePage, InitialValueResolver initialValueResolver, ProvidedValueSetEntriesResolver findProvidedValueSetEntries, Map<ItemId, List<Command<?>>> itemCommands, Date completed, Date opened, Date lastAnswer) {
        this.tenantId = tenantId;
        this.sessionId = sessionId;
        this.language = language;
        this.initialValueResolver = initialValueResolver;
        this.findProvidedValueSetEntries = findProvidedValueSetEntries;
        this.itemCommands = itemCommands == null ? Map.of() : itemCommands;
        this.activePage = activePage != null ? IdUtils.toId(activePage) : null;
        this.completed = completed;
        this.opened = opened;
        this.lastAnswer = lastAnswer;
    }

    @Override
    public void startProgram(@NonNull Program program) {
        this.program = program;
    }

    @Override
    public Optional<ProgramVisitor.ItemVisitor> visitItems() {
        return Optional.of(new AbstractItemVisitor(){

            @Override
            public void visitVariableItem(@NonNull VariableItem item) {
                CreateDialobSessionProgramVisitor.this.items.add(CreateDialobSessionProgramVisitor.this.createItemState(item.getId(), item, item.isPublished()));
            }

            @Override
            public void visitDisplayItem(@NonNull DisplayItem displayItem) {
                ItemState itemState = CreateDialobSessionProgramVisitor.this.createItemState(displayItem.getId(), displayItem, true);
                if (displayItem.isPrototype()) {
                    CreateDialobSessionProgramVisitor.this.prototypeItems.add(itemState);
                } else {
                    CreateDialobSessionProgramVisitor.this.items.add(itemState);
                }
            }

            @Override
            public void visitGroup(@NonNull Group group) {
                ItemState itemState = CreateDialobSessionProgramVisitor.this.createItemState(group.getId(), group, true);
                if (group.isPrototype()) {
                    CreateDialobSessionProgramVisitor.this.prototypeItems.add(itemState);
                } else if (Utils.isRowgroup(group.getType())) {
                    CreateDialobSessionProgramVisitor.this.rowGroups.add(itemState);
                } else {
                    CreateDialobSessionProgramVisitor.this.items.add(itemState);
                }
            }
        });
    }

    @Override
    public Optional<ProgramVisitor.ErrorVisitor> visitErrors() {
        return Optional.of(error -> {
            ImmutableErrorId targetId = ImmutableErrorId.of(error.getItemId(), error.getCode());
            ErrorState errorState = new ErrorState((ErrorId)targetId, (String)null);
            if (error.isPrototype()) {
                this.errorPrototypes.add(errorState);
            } else {
                this.errors.add(errorState);
                this.collectItemUpdateCommands(targetId);
            }
        });
    }

    @Override
    public Optional<ProgramVisitor.ValueSetVisitor> visitValueSets() {
        return Optional.of(valueSet -> {
            this.updates.add(CommandFactory.updateValueSet(ImmutableValueSetId.of(valueSet.getId()), valueSet.getEntries()));
            ValueSetState valueSetState = new ValueSetState(valueSet.getId());
            valueSetState = valueSetState.update().setEntries(this.findProvidedValueSetEntries.apply(valueSetState.getId())).get();
            this.valueSets.add(valueSetState);
        });
    }

    @NonNull
    private ItemState createItemState(@NonNull ItemId itemId, @NonNull Item item, boolean published) {
        boolean displayItem;
        Object defaultValue = null;
        Object answer = null;
        Object value = null;
        ItemId activePage = null;
        if (!Utils.isNote(item.getType())) {
            defaultValue = item.getDefaultValue().map(o -> Utils.parse(item.getValueType(), o)).orElse(null);
            if (!item.isPrototype()) {
                answer = this.initialValueResolver.apply(item.getId(), item).orElse(null);
            }
            if (item.getValueType() != null) {
                value = Utils.parse(item.getValueType(), answer);
            }
            if (Utils.isVariable(item.getType())) {
                answer = null;
            }
            if (DialobSession.QUESTIONNAIRE_REF.equals(item.getId())) {
                activePage = this.activePage;
            }
        }
        String view = (displayItem = item instanceof DisplayItem) ? ((DisplayItem)item).getView() : null;
        boolean hasCustomProps = displayItem && ((DisplayItem)item).getProps() != null;
        ItemState itemState = new ItemState(itemId, item.isPrototype() ? itemId : null, item.getType(), view, published, item.getValueSetId().orElse(null), answer, value, defaultValue, activePage).update().setHasCustomProps(hasCustomProps).get();
        if (!item.isPrototype()) {
            this.collectItemUpdateCommands(itemId);
        }
        return itemState;
    }

    private void collectItemUpdateCommands(ItemId targetId) {
        this.itemCommands.entrySet().stream().filter(entry -> IdUtils.matches(targetId, (ItemId)entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).map(command -> {
            UpdateCommand updateCommand;
            if (command instanceof UpdateCommand && (updateCommand = (UpdateCommand)command).getTargetId().isPartial()) {
                command = updateCommand.withTargetId(targetId);
            }
            return command;
        }).forEach(this.updates::add);
    }

    @Override
    public void end() {
        this.rowGroups.stream().flatMap(rowGroup -> {
            List rowNumbers = (List)rowGroup.getValue();
            if (rowNumbers == null) {
                return Stream.empty();
            }
            return rowNumbers.stream().flatMap(rowNumber -> {
                ImmutableItemIndex rowId = ImmutableItemIndex.of(rowNumber.intValue(), Optional.of(rowGroup.getId()));
                return Stream.concat(Stream.of(rowId), this.program.getItems().stream().filter(itemPrototype -> itemPrototype.isPrototype() && IdUtils.matches(rowId, itemPrototype.getId())).map(itemPrototype -> (Group)itemPrototype).map(groupPrototype -> (RowItemsExpression)groupPrototype.getItemsExpression()).flatMap(rowItemsExpression -> rowItemsExpression.getItemIds().stream()).map(ItemId::getValue).map(name -> ImmutableItemRef.of(name, Optional.of(rowId))));
            });
        }).flatMap(itemIdToCreate -> this.prototypeItems.stream().filter(prototype -> IdUtils.matches(prototype.getId(), itemIdToCreate)).map(prototype -> {
            ItemState newItem = prototype.withId((ItemId)itemIdToCreate);
            newItem = this.program.findItemsBy(id -> IdUtils.matches(id, itemIdToCreate)).findFirst().map(item -> {
                Group group;
                Expression expression;
                List<ItemId> rowItems = List.of();
                if (item instanceof Group && (expression = (group = (Group)item).getItemsExpression()) instanceof RowItemsExpression) {
                    RowItemsExpression rowItemsExpression = (RowItemsExpression)expression;
                    ImmutableScope scope = ImmutableScope.of(itemIdToCreate, Set.of());
                    rowItems = rowItemsExpression.getItemIds().stream().map(itemId -> scope.mapTo((ItemId)itemId, true)).toList();
                }
                Object newAnswer = this.initialValueResolver.apply((ItemId)itemIdToCreate, (Item)item).orElse(null);
                return prototype.withId((ItemId)itemIdToCreate).update().setAnswer(newAnswer).setValue(Utils.parse(prototype.getType(), newAnswer)).setItems(rowItems).get();
            }).orElse(newItem);
            this.collectItemUpdateCommands((ItemId)itemIdToCreate);
            this.errorPrototypes.stream().filter(errorPrototype -> IdUtils.matches(itemIdToCreate, errorPrototype.getItemId())).map(errorPrototype -> errorPrototype.withErrorId(errorPrototype.getId().withItemId((ItemId)itemIdToCreate))).peek(errorPrototype -> this.collectItemUpdateCommands(errorPrototype.getId())).forEach(this.errors::add);
            return newItem;
        })).forEach(this.items::add);
        this.rowGroups.stream().map(rowGroup -> {
            if (rowGroup.getValue() != null) {
                return rowGroup.update().setItems(((List)rowGroup.getValue()).stream().map(rowNumber -> ImmutableItemIndex.of(rowNumber.intValue(), Optional.of(rowGroup.getId()))).toList()).get();
            }
            return rowGroup;
        }).forEach(this.items::add);
        if (this.activePage == null) {
            this.updates.add(CommandFactory.nextPage());
        }
        this.dialobSession = new DialobSession(this.tenantId, this.sessionId, null, this.language, this.items, this.prototypeItems, this.valueSets, this.errors, this.errorPrototypes, this.completed, this.opened, this.lastAnswer);
    }

    @Generated
    public DialobSession getDialobSession() {
        return this.dialobSession;
    }

    @Generated
    public List<Command<?>> getUpdates() {
        return this.updates;
    }

    @FunctionalInterface
    public static interface InitialValueResolver {
        public Optional<Object> apply(ItemId var1, Item var2);
    }

    @FunctionalInterface
    public static interface ProvidedValueSetEntriesResolver {
        public List<ValueSetState.Entry> apply(ValueSetId var1);
    }
}

