/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.model.DisplayItem;
import io.dialob.session.engine.program.model.Item;
import io.dialob.session.engine.program.model.ProgramNode;
import io.dialob.session.engine.program.model.ProgramVisitor;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface Program
extends ProgramNode {
    @NonNull
    public String getId();

    @NonNull
    public Item getRootItem();

    public List<Item> getItems();

    public List<ValueSet> getValueSets();

    default public void accept(ProgramVisitor visitor) {
        ArrayList errors = new ArrayList();
        visitor.startProgram(this);
        visitor.visitItems().ifPresent(itemVisitor -> {
            itemVisitor.visitItem(this.getRootItem());
            this.getItems().forEach(item -> {
                itemVisitor.visitItem((Item)item);
                if (item instanceof DisplayItem) {
                    DisplayItem displayItem = (DisplayItem)item;
                    errors.addAll(displayItem.getErrors());
                }
            });
            itemVisitor.end();
        });
        visitor.visitErrors().ifPresent(errorVisitor -> {
            errors.forEach(errorVisitor::visitError);
            errorVisitor.end();
        });
        visitor.visitValueSets().ifPresent(valueSetVisitor -> {
            this.getValueSets().forEach(valueSetVisitor::visitValueSet);
            valueSetVisitor.end();
        });
        visitor.end();
    }

    default public Stream<Item> findItemsBy(Predicate<ItemId> matcher) {
        Stream<Item> itemStream = this.getItems().stream().filter(item -> matcher.test(item.getId()));
        if (matcher.test(this.getRootItem().getId())) {
            return Stream.concat(Stream.of(this.getRootItem()), itemStream);
        }
        return itemStream;
    }

    default public Optional<Item> getItem(ItemId id) {
        if (IdUtils.QUESTIONNAIRE_ID.equals(id)) {
            return Optional.of(this.getRootItem());
        }
        for (Item item : this.getItems()) {
            if (!id.equals(item.getId())) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }
}

