/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.program.model.Item;
import io.dialob.session.engine.program.model.StructuralNode;
import io.dialob.session.engine.program.model.VariableItem;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="VariableItem", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableVariableItem
implements VariableItem {
    private final boolean isPrototype;
    private final ItemId id;
    private final String type;
    @Nullable
    private final String valueSetId;
    @Nullable
    private final Object defaultValue;
    private final Expression valueExpression;
    private final boolean isAsync;
    private final boolean isPublished;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVariableItem(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.valueSetId = builder.valueSetId;
        this.defaultValue = builder.defaultValue;
        this.valueExpression = builder.valueExpression;
        if (builder.isPrototypeIsSet()) {
            this.initShim.isPrototype(builder.isPrototype);
        }
        if (builder.isAsyncIsSet()) {
            this.initShim.isAsync(builder.isAsync);
        }
        if (builder.isPublishedIsSet()) {
            this.initShim.isPublished(builder.isPublished);
        }
        this.isPrototype = this.initShim.isPrototype();
        this.isAsync = this.initShim.isAsync();
        this.isPublished = this.initShim.isPublished();
        this.initShim = null;
    }

    private ImmutableVariableItem(boolean isPrototype, ItemId id, String type, @Nullable String valueSetId, @Nullable Object defaultValue, Expression valueExpression, boolean isAsync, boolean isPublished) {
        this.isPrototype = isPrototype;
        this.id = id;
        this.type = type;
        this.valueSetId = valueSetId;
        this.defaultValue = defaultValue;
        this.valueExpression = valueExpression;
        this.isAsync = isAsync;
        this.isPublished = isPublished;
        this.initShim = null;
    }

    private boolean isPrototypeInitialize() {
        return VariableItem.super.isPrototype();
    }

    private boolean isAsyncInitialize() {
        return VariableItem.super.isAsync();
    }

    private boolean isPublishedInitialize() {
        return VariableItem.super.isPublished();
    }

    @Override
    public boolean isPrototype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPrototype() : this.isPrototype;
    }

    @Override
    public ItemId getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<String> getValueSetId() {
        return Optional.ofNullable(this.valueSetId);
    }

    @Override
    public Optional<Object> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public Expression getValueExpression() {
        return this.valueExpression;
    }

    @Override
    public boolean isAsync() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAsync() : this.isAsync;
    }

    @Override
    public boolean isPublished() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublished() : this.isPublished;
    }

    public final ImmutableVariableItem withIsPrototype(boolean value) {
        if (this.isPrototype == value) {
            return this;
        }
        return new ImmutableVariableItem(value, this.id, this.type, this.valueSetId, this.defaultValue, this.valueExpression, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withId(ItemId value) {
        if (this.id == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableVariableItem(this.isPrototype, newValue, this.type, this.valueSetId, this.defaultValue, this.valueExpression, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableVariableItem(this.isPrototype, this.id, newValue, this.valueSetId, this.defaultValue, this.valueExpression, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withValueSetId(String value) {
        String newValue = Objects.requireNonNull(value, "valueSetId");
        if (Objects.equals(this.valueSetId, newValue)) {
            return this;
        }
        return new ImmutableVariableItem(this.isPrototype, this.id, this.type, newValue, this.defaultValue, this.valueExpression, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withValueSetId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.valueSetId, value)) {
            return this;
        }
        return new ImmutableVariableItem(this.isPrototype, this.id, this.type, value, this.defaultValue, this.valueExpression, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withDefaultValue(Object value) {
        Object newValue = Objects.requireNonNull(value, "defaultValue");
        if (this.defaultValue == newValue) {
            return this;
        }
        return new ImmutableVariableItem(this.isPrototype, this.id, this.type, this.valueSetId, newValue, this.valueExpression, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withDefaultValue(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.defaultValue == value) {
            return this;
        }
        return new ImmutableVariableItem(this.isPrototype, this.id, this.type, this.valueSetId, value, this.valueExpression, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withValueExpression(Expression value) {
        if (this.valueExpression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "valueExpression");
        return new ImmutableVariableItem(this.isPrototype, this.id, this.type, this.valueSetId, this.defaultValue, newValue, this.isAsync, this.isPublished);
    }

    public final ImmutableVariableItem withIsAsync(boolean value) {
        if (this.isAsync == value) {
            return this;
        }
        return new ImmutableVariableItem(this.isPrototype, this.id, this.type, this.valueSetId, this.defaultValue, this.valueExpression, value, this.isPublished);
    }

    public final ImmutableVariableItem withIsPublished(boolean value) {
        if (this.isPublished == value) {
            return this;
        }
        return new ImmutableVariableItem(this.isPrototype, this.id, this.type, this.valueSetId, this.defaultValue, this.valueExpression, this.isAsync, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVariableItem && this.equalsByValue((ImmutableVariableItem)another);
    }

    private boolean equalsByValue(ImmutableVariableItem another) {
        return this.isPrototype == another.isPrototype && this.id.equals(another.id) && this.type.equals(another.type) && Objects.equals(this.valueSetId, another.valueSetId) && Objects.equals(this.defaultValue, another.defaultValue) && this.valueExpression.equals(another.valueExpression) && this.isAsync == another.isAsync && this.isPublished == another.isPublished;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isPrototype);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.valueSetId);
        h += (h << 5) + Objects.hashCode(this.defaultValue);
        h += (h << 5) + this.valueExpression.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isAsync);
        h += (h << 5) + Booleans.hashCode((boolean)this.isPublished);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"VariableItem").omitNullValues().add("isPrototype", this.isPrototype).add("id", (Object)this.id).add("type", (Object)this.type).add("valueSetId", (Object)this.valueSetId).add("defaultValue", this.defaultValue).add("valueExpression", (Object)this.valueExpression).add("isAsync", this.isAsync).add("isPublished", this.isPublished).toString();
    }

    public static ImmutableVariableItem copyOf(VariableItem instance) {
        if (instance instanceof ImmutableVariableItem) {
            return (ImmutableVariableItem)instance;
        }
        return ImmutableVariableItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VariableItem", generator="Immutables")
    private final class InitShim {
        private byte isPrototypeBuildStage = 0;
        private boolean isPrototype;
        private byte isAsyncBuildStage = 0;
        private boolean isAsync;
        private byte isPublishedBuildStage = 0;
        private boolean isPublished;

        private InitShim() {
        }

        boolean isPrototype() {
            if (this.isPrototypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPrototypeBuildStage == 0) {
                boolean computedValue;
                this.isPrototypeBuildStage = (byte)-1;
                this.isPrototype = computedValue = ImmutableVariableItem.this.isPrototypeInitialize();
                this.isPrototypeBuildStage = 1;
            }
            return this.isPrototype;
        }

        void isPrototype(boolean isPrototype) {
            this.isPrototype = isPrototype;
            this.isPrototypeBuildStage = 1;
        }

        boolean isAsync() {
            if (this.isAsyncBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAsyncBuildStage == 0) {
                boolean computedValue;
                this.isAsyncBuildStage = (byte)-1;
                this.isAsync = computedValue = ImmutableVariableItem.this.isAsyncInitialize();
                this.isAsyncBuildStage = 1;
            }
            return this.isAsync;
        }

        void isAsync(boolean isAsync) {
            this.isAsync = isAsync;
            this.isAsyncBuildStage = 1;
        }

        boolean isPublished() {
            if (this.isPublishedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPublishedBuildStage == 0) {
                boolean computedValue;
                this.isPublishedBuildStage = (byte)-1;
                this.isPublished = computedValue = ImmutableVariableItem.this.isPublishedInitialize();
                this.isPublishedBuildStage = 1;
            }
            return this.isPublished;
        }

        void isPublished(boolean isPublished) {
            this.isPublished = isPublished;
            this.isPublishedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isPrototypeBuildStage == -1) {
                attributes.add("isPrototype");
            }
            if (this.isAsyncBuildStage == -1) {
                attributes.add("isAsync");
            }
            if (this.isPublishedBuildStage == -1) {
                attributes.add("isPublished");
            }
            return "Cannot build VariableItem, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="VariableItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_VALUE_EXPRESSION = 4L;
        private static final long OPT_BIT_IS_PROTOTYPE = 1L;
        private static final long OPT_BIT_IS_ASYNC = 2L;
        private static final long OPT_BIT_IS_PUBLISHED = 4L;
        private long initBits = 7L;
        private long optBits;
        private boolean isPrototype;
        @Nullable
        private ItemId id;
        @Nullable
        private String type;
        @Nullable
        private String valueSetId;
        @Nullable
        private Object defaultValue;
        @Nullable
        private Expression valueExpression;
        private boolean isAsync;
        private boolean isPublished;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Item instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(VariableItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StructuralNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<String> valueSetIdOptional;
            Optional<Object> defaultValueOptional;
            StructuralNode instance;
            long bits = 0L;
            if (object instanceof Item) {
                instance = (Item)object;
                if ((bits & 0x10L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    this.type(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.isPrototype(instance.isPrototype());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    defaultValueOptional = instance.getDefaultValue();
                    if (defaultValueOptional.isPresent()) {
                        this.defaultValue(defaultValueOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    valueSetIdOptional = instance.getValueSetId();
                    if (valueSetIdOptional.isPresent()) {
                        this.valueSetId(valueSetIdOptional);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof VariableItem) {
                instance = (VariableItem)object;
                this.valueExpression(instance.getValueExpression());
                if ((bits & 4L) == 0L) {
                    this.isPrototype(instance.isPrototype());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    defaultValueOptional = instance.getDefaultValue();
                    if (defaultValueOptional.isPresent()) {
                        this.defaultValue(defaultValueOptional);
                    }
                    bits |= 1L;
                }
                this.isPublished(instance.isPublished());
                if ((bits & 8L) == 0L) {
                    valueSetIdOptional = instance.getValueSetId();
                    if (valueSetIdOptional.isPresent()) {
                        this.valueSetId(valueSetIdOptional);
                    }
                    bits |= 8L;
                }
                this.isAsync(instance.isAsync());
                if ((bits & 0x10L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    this.type(instance.getType());
                    bits |= 2L;
                }
            }
            if (object instanceof StructuralNode) {
                instance = (StructuralNode)object;
                if ((bits & 4L) == 0L) {
                    this.isPrototype(instance.isPrototype());
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder isPrototype(boolean isPrototype) {
            this.isPrototype = isPrototype;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(ItemId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(String valueSetId) {
            this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(Optional<String> valueSetId) {
            this.valueSetId = valueSetId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultValue(Object defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultValue(Optional<? extends Object> defaultValue) {
            this.defaultValue = defaultValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueExpression(Expression valueExpression) {
            this.valueExpression = Objects.requireNonNull(valueExpression, "valueExpression");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isAsync(boolean isAsync) {
            this.isAsync = isAsync;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isPublished(boolean isPublished) {
            this.isPublished = isPublished;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableVariableItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVariableItem(this);
        }

        private boolean isPrototypeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isAsyncIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isPublishedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("valueExpression");
            }
            return "Cannot build VariableItem, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

