/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.ImmutableBinaryOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsActiveOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsAnsweredOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsBlankOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsDisabledOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsNullOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableIsRequiredOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableNotOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableVariableReference;
import io.dialob.session.engine.program.expr.arith.InfixOperator;
import io.dialob.session.engine.program.expr.arith.Reducers;
import io.dialob.session.engine.program.expr.arith.VariableReference;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;

public interface Operators {
    public InfixOperator eq(Expression var1, Expression var2);

    public InfixOperator ne(Expression var1, Expression var2);

    public InfixOperator le(Expression var1, Expression var2);

    public InfixOperator lt(Expression var1, Expression var2);

    public InfixOperator ge(Expression var1, Expression var2);

    public InfixOperator gt(Expression var1, Expression var2);

    public static Expression and(Expression ... expressions) {
        return ImmutableBinaryOperator.builder().addNodes(expressions).reducer(Reducers.Bool.AND).build();
    }

    public static Expression or(Expression ... expressions) {
        return ImmutableBinaryOperator.builder().addNodes(expressions).reducer(Reducers.Bool.OR).build();
    }

    public static Expression isAnswered(ItemId id) {
        return ImmutableIsAnsweredOperator.builder().questionId(id).build();
    }

    public static Expression isBlank(ItemId id) {
        return ImmutableIsBlankOperator.builder().questionId(id).build();
    }

    public static Expression isNull(ItemId id) {
        return ImmutableIsNullOperator.builder().itemId(id).build();
    }

    public static Expression isActive(ItemId id) {
        return ImmutableIsActiveOperator.builder().itemId(id).build();
    }

    public static Expression isRequired(ItemId id) {
        return ImmutableIsRequiredOperator.builder().itemId(id).build();
    }

    public static Expression not(Expression expression) {
        return ImmutableNotOperator.builder().expression(expression).build();
    }

    public static Expression isDisabled(ItemId id) {
        return ImmutableIsDisabledOperator.builder().itemId(id).build();
    }

    public static ItemId ref(String id) {
        return IdUtils.toId(id);
    }

    public static VariableReference<?> var(@NonNull ItemId id, @NonNull ValueType valueType) {
        return ImmutableVariableReference.builder().itemId(id).valueType(valueType).build();
    }

    public static VariableReference<?> var(@NonNull String id, @NonNull ValueType valueType) {
        return Operators.var(Operators.ref(id), valueType);
    }
}

