/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import java.lang.invoke.LambdaMetafactory;
import java.util.Set;
import java.util.function.Predicate;
import org.immutables.value.Value;

@Value.Immutable
public interface IsValidOperator
extends Expression {
    @Value.Parameter
    public ItemId getItemId();

    @Override
    default public Boolean eval(@NonNull EvalContext context) {
        ItemId itemId = context.mapTo(this.getItemId(), false);
        return context.getItemState(itemId).map(itemState -> {
            if (Utils.isQuestionType(itemState)) {
                return context.getErrorStates().stream().filter(ErrorState::isActive).map(ErrorState::getItemId).noneMatch((Predicate<ItemId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/dialob/session/engine/session/model/ItemId;)Z)((ItemId)itemId));
            }
            return !itemState.isInvalidAnswers();
        }).orElse(true);
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return Set.of(EventMatchers.errorActivity(EventMatchers.targetError(this.getItemId())));
    }
}

