/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.expr.arith.InfixOperator;
import java.util.Collection;
import java.util.Collections;
import org.immutables.value.Value;

@Value.Immutable
public interface IntersectionOperator
extends InfixOperator {
    @Override
    default public Object eval(@NonNull EvalContext evalContext) {
        Object lhs = this.getLhs().eval(evalContext);
        Object rhs = this.getRhs().eval(evalContext);
        if (lhs instanceof Collection) {
            Collection lhc = (Collection)lhs;
            if (rhs instanceof Collection) {
                Collection rhc = (Collection)rhs;
                if (!lhc.isEmpty() && !rhc.isEmpty()) {
                    return rhc.stream().filter(lhc::contains).toList();
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.arrayOf((ValueType)ValueType.STRING);
    }
}

