/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.expr.arith.ValueSetToListOperator;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValueSetToListOperator", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableValueSetToListOperator
implements ValueSetToListOperator {
    private final ValueSetId valueSetId;

    private ImmutableValueSetToListOperator(ValueSetId valueSetId) {
        this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
    }

    private ImmutableValueSetToListOperator(ImmutableValueSetToListOperator original, ValueSetId valueSetId) {
        this.valueSetId = valueSetId;
    }

    @Override
    public ValueSetId getValueSetId() {
        return this.valueSetId;
    }

    public final ImmutableValueSetToListOperator withValueSetId(ValueSetId value) {
        if (this.valueSetId == value) {
            return this;
        }
        ValueSetId newValue = Objects.requireNonNull(value, "valueSetId");
        return new ImmutableValueSetToListOperator(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueSetToListOperator && this.equalsByValue((ImmutableValueSetToListOperator)another);
    }

    private boolean equalsByValue(ImmutableValueSetToListOperator another) {
        return this.valueSetId.equals(another.valueSetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueSetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueSetToListOperator").omitNullValues().add("valueSetId", (Object)this.valueSetId).toString();
    }

    public static ImmutableValueSetToListOperator of(ValueSetId valueSetId) {
        return new ImmutableValueSetToListOperator(valueSetId);
    }

    public static ImmutableValueSetToListOperator copyOf(ValueSetToListOperator instance) {
        if (instance instanceof ImmutableValueSetToListOperator) {
            return (ImmutableValueSetToListOperator)instance;
        }
        return ImmutableValueSetToListOperator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueSetToListOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE_SET_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private ValueSetId valueSetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValueSetToListOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.valueSetId(instance.getValueSetId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(ValueSetId valueSetId) {
            this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableValueSetToListOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueSetToListOperator(null, this.valueSetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueSetId");
            }
            return "Cannot build ValueSetToListOperator, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

