/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.expr.arith.AbstractLogicalOperator;
import io.dialob.session.engine.program.expr.arith.InfixOperator;
import io.dialob.session.engine.program.expr.arith.LeOperator;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LeOperator", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableLeOperator<T extends Comparable<T>>
implements LeOperator<T> {
    private final Expression lhs;
    private final Expression rhs;

    private ImmutableLeOperator(Expression lhs, Expression rhs) {
        this.lhs = Objects.requireNonNull(lhs, "lhs");
        this.rhs = Objects.requireNonNull(rhs, "rhs");
    }

    private ImmutableLeOperator(ImmutableLeOperator<T> original, Expression lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Expression getLhs() {
        return this.lhs;
    }

    @Override
    public Expression getRhs() {
        return this.rhs;
    }

    public final ImmutableLeOperator<T> withLhs(Expression value) {
        if (this.lhs == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "lhs");
        return new ImmutableLeOperator<T>(this, newValue, this.rhs);
    }

    public final ImmutableLeOperator<T> withRhs(Expression value) {
        if (this.rhs == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "rhs");
        return new ImmutableLeOperator<T>(this, this.lhs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLeOperator && this.equalsByValue((ImmutableLeOperator)another);
    }

    private boolean equalsByValue(ImmutableLeOperator<?> another) {
        return this.lhs.equals(another.lhs) && this.rhs.equals(another.rhs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lhs.hashCode();
        h += (h << 5) + this.rhs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LeOperator").omitNullValues().add("lhs", (Object)this.lhs).add("rhs", (Object)this.rhs).toString();
    }

    public static <T extends Comparable<T>> ImmutableLeOperator<T> of(Expression lhs, Expression rhs) {
        return new ImmutableLeOperator<T>(lhs, rhs);
    }

    public static <T extends Comparable<T>> ImmutableLeOperator<T> copyOf(LeOperator<T> instance) {
        if (instance instanceof ImmutableLeOperator) {
            return (ImmutableLeOperator)instance;
        }
        return ImmutableLeOperator.builder().from(instance).build();
    }

    public static <T extends Comparable<T>> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="LeOperator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends Comparable<T>> {
        private static final long INIT_BIT_LHS = 1L;
        private static final long INIT_BIT_RHS = 2L;
        private long initBits = 3L;
        @Nullable
        private Expression lhs;
        @Nullable
        private Expression rhs;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(InfixOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AbstractLogicalOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(LeOperator<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            InfixOperator instance;
            long bits = 0L;
            if (object instanceof InfixOperator) {
                instance = (InfixOperator)object;
                if ((bits & 2L) == 0L) {
                    this.rhs(instance.getRhs());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.lhs(instance.getLhs());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractLogicalOperator) {
                instance = (AbstractLogicalOperator)object;
                if ((bits & 2L) == 0L) {
                    this.rhs(instance.getRhs());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.lhs(instance.getLhs());
                    bits |= 1L;
                }
            }
            if (object instanceof LeOperator) {
                instance = (LeOperator)object;
                if ((bits & 2L) == 0L) {
                    this.rhs(instance.getRhs());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.lhs(instance.getLhs());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> lhs(Expression lhs) {
            this.lhs = Objects.requireNonNull(lhs, "lhs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> rhs(Expression rhs) {
            this.rhs = Objects.requireNonNull(rhs, "rhs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLeOperator<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLeOperator(null, this.lhs, this.rhs);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lhs");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rhs");
            }
            return "Cannot build LeOperator, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

