/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.ImmutableAsyncFunctionCall;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableObject;
import org.immutables.value.Value;

@Value.Immutable
public interface FunctionCallOperator
extends Expression {
    @Override
    @NonNull
    public ValueType getValueType();

    public String getFunctionName();

    public List<Expression> getArgs();

    @Override
    default public Object eval(@NonNull EvalContext evalContext) {
        FunctionRegistry functionRegistry = evalContext.getFunctionRegistry();
        Object[] args = this.getArgs().stream().map(arg -> arg.eval(evalContext)).toArray();
        if (functionRegistry.isAsyncFunction(this.getFunctionName())) {
            return ImmutableAsyncFunctionCall.builder().functionName(this.getFunctionName()).args(args).build();
        }
        final MutableObject holder = new MutableObject();
        functionRegistry.invokeFunction(new FunctionRegistry.FunctionCallback(){

            public void succeeded(Object result) {
                holder.setValue(result);
            }

            public void failed(@NonNull String error) {
            }
        }, this.getFunctionName(), args);
        return holder.getValue();
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        HashSet deps = new HashSet();
        this.getArgs().forEach(arg -> deps.addAll(arg.getEvalRequiredConditions()));
        return Set.copyOf(deps);
    }
}

