/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.expr.arith.Pair;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface ConditionalListOperator<T>
extends Expression {
    public List<Pair<Expression, T>> getItems();

    @Override
    default public Object eval(@NonNull EvalContext evalContext) {
        return this.getItems().stream().filter(item -> (Boolean)((Expression)item.getLeft()).eval(evalContext)).map(Pair::getRight).toList();
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.arrayOf((ValueType)ValueType.STRING);
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getItems().stream().map(Pair::getLeft).map(Expression::getEvalRequiredConditions).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }
}

