/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface ConcatOperator
extends Expression {
    public List<Expression> getExpressions();

    @Override
    default public String eval(@NonNull EvalContext context) {
        return this.getExpressions().stream().map(expression -> (String)expression.eval(context)).collect(Collectors.joining());
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getExpressions().stream().map(Expression::getEvalRequiredConditions).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }
}

