/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class OutputFormatter {
    private final Locale locale;
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter timeFormatter;

    public OutputFormatter(String language) {
        this.locale = language != null ? Locale.of(language) : Locale.getDefault();
        this.dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(this.locale);
        this.timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(this.locale);
    }

    public String format(Object value) {
        return this.format(value, null);
    }

    public String format(Object value, String format) {
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            DateTimeFormatter df = format == null ? this.dateFormatter : DateTimeFormatter.ofPattern(format, this.locale);
            return date.format(df);
        }
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            DateTimeFormatter df = format == null ? this.timeFormatter : DateTimeFormatter.ofPattern(format, this.locale);
            return time.format(df);
        }
        if (value instanceof Number) {
            NumberFormat numberFormat = NumberFormat.getInstance(this.locale);
            if (StringUtils.isBlank((CharSequence)format)) {
                return numberFormat.format(value);
            }
            DecimalFormat df = (DecimalFormat)numberFormat;
            df.applyPattern(format);
            return df.format(value);
        }
        return value.toString();
    }
}

