/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr;

import edu.umd.cs.findbugs.annotations.Nullable;
import lombok.Generated;

public enum OperatorSymbol {
    PLUS("+"),
    MINUS("-"),
    MULT("*"),
    DIV("/"),
    NEG("neg"),
    NOT("not", true),
    AND("and"),
    OR("or"),
    NE("!="),
    EQ("="),
    LT("<"),
    LE("<="),
    GE(">="),
    GT(">"),
    NOT_IN("notIn", true),
    IN("in"),
    NOT_MATCHES("notMatches", true),
    MATCHES("matches"),
    NOT_ANSWERED("isNotAnswered", true),
    ANSWERED("isAnswered"),
    NOT_BLANK("isNotBlank", true),
    BLANK("isBlank"),
    NOT_NULL("isNotNull", true),
    NULL("isNull"),
    COUNT("count"),
    NOT_VALID("isNotValid", true),
    VALID("isValid"),
    SUM("sumOf"),
    MIN("minOf"),
    MAX("maxOf"),
    ALL("allOf"),
    ANY("anyOf");

    private final String symbol;
    private final boolean not;

    @Nullable
    public static OperatorSymbol mapOp(String op) {
        for (OperatorSymbol operator : OperatorSymbol.values()) {
            if (!operator.symbol.equals(op)) continue;
            return operator;
        }
        return null;
    }

    private OperatorSymbol(String symbol) {
        this(symbol, false);
    }

    private OperatorSymbol(String symbol, boolean not) {
        this.symbol = symbol;
        this.not = not;
    }

    @Generated
    public boolean isNot() {
        return this.not;
    }
}

