/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.program.expr.NotOnPageExpression;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NotOnPageExpression", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableNotOnPageExpression
implements NotOnPageExpression {
    private final ItemId page;

    private ImmutableNotOnPageExpression(ItemId page) {
        this.page = Objects.requireNonNull(page, "page");
    }

    private ImmutableNotOnPageExpression(ImmutableNotOnPageExpression original, ItemId page) {
        this.page = page;
    }

    @Override
    public ItemId getPage() {
        return this.page;
    }

    public final ImmutableNotOnPageExpression withPage(ItemId value) {
        if (this.page == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "page");
        return new ImmutableNotOnPageExpression(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotOnPageExpression && this.equalsByValue((ImmutableNotOnPageExpression)another);
    }

    private boolean equalsByValue(ImmutableNotOnPageExpression another) {
        return this.page.equals(another.page);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.page.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NotOnPageExpression").omitNullValues().add("page", (Object)this.page).toString();
    }

    public static ImmutableNotOnPageExpression of(ItemId page) {
        return new ImmutableNotOnPageExpression(page);
    }

    public static ImmutableNotOnPageExpression copyOf(NotOnPageExpression instance) {
        if (instance instanceof ImmutableNotOnPageExpression) {
            return (ImmutableNotOnPageExpression)instance;
        }
        return ImmutableNotOnPageExpression.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NotOnPageExpression", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAGE = 1L;
        private long initBits = 1L;
        @Nullable
        private ItemId page;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NotOnPageExpression instance) {
            Objects.requireNonNull(instance, "instance");
            this.page(instance.getPage());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder page(ItemId page) {
            this.page = Objects.requireNonNull(page, "page");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableNotOnPageExpression build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNotOnPageExpression(null, this.page);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("page");
            }
            return "Cannot build NotOnPageExpression, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

