/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface ExpressionList
extends Expression {
    public List<Expression> getExpressions();

    @Override
    default public Object eval(@NonNull EvalContext evalContext) {
        return this.getExpressions().stream().map(expression -> expression.eval(evalContext)).filter(Objects::nonNull).flatMap(o -> {
            if (o instanceof Collection) {
                Collection collection = (Collection)o;
                return collection.stream();
            }
            return Stream.of(o);
        }).filter(Objects::nonNull).toList();
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return ValueType.arrayOf((ValueType)ValueType.STRING);
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        HashSet deps = new HashSet();
        this.getExpressions().forEach(arg -> deps.addAll(arg.getEvalRequiredConditions()));
        return Set.copyOf(deps);
    }
}

